/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Mon Oct 24 02:15:57 2005 by Jeff Dalton
 * Copyright: (c) 2005, AIAI, University of Edinburgh
 */

package ix.iplan;

import ix.util.Debug;

public class ErrorPlanEvaluation implements PlanEvaluation {

    private Throwable t;

    public ErrorPlanEvaluation(Throwable t) {
	this.t = t;
    }

    public Object getValue() {
	return "Error";
    }

    public boolean hasDetails() {
	return true;
    }

    public void detailsRequested() {
	Debug.displayException("The problem with this evaluation was", t);
    }

}
