/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sat Nov 13 17:14:52 2004 by Jeff Dalton
 * Copyright: (c) 2004, AIAI, University of Edinburgh
 */

package ix.ip2;

import java.util.*;

import ix.icore.*;
import ix.util.*;

/**
 * Explains that a {@link HandlerAction} is not ready to be used
 * because certain variables do not yet have values.
 *
 * @see HandlerAction#isReady()
 * @see HandlerAction#getUnreadyReason()
 */
public class UnboundVariablesUnreadyReason extends ActionUnreadyReason {

    protected Set unboundVars;

    /**
     * Creates an unready reason for the specified action and variables.
     */
    public UnboundVariablesUnreadyReason(HandlerAction action,
					 Set unboundVars) {
	super(action);
	this.unboundVars = unboundVars;
    }

    /**
     * Creates an unready reason for the specified action and
     * the unbound variables in the agenda-item's pattern.
     */
    public UnboundVariablesUnreadyReason(HandlerAction action,
					 AgendaItem item) {
	this(action, Variable.unboundVarsIn
		         (Variable.varsIn(item.getPattern())));
    }

    public Set getUnboundVars() {
	return unboundVars;
    }

    public String[] getExplanation() {
	return Strings.foldToArray
	    ("Unbound variables: " + Strings.conjunction(unboundVars));
    }

}
