/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Tue Aug 29 19:31:00 2006 by Jeff Dalton
 * Copyright: (c) 2006, AIAI, University of Edinburgh
 */

package ix.ip2;

import java.util.*;

import ix.icore.*;
import ix.isim.ISimTimer;
import ix.util.lisp.*;

public class SyncSimulationTimeHandler extends ActivityHandler {

    public static final Symbol SYNCHRONIZE_SIMULATION_TIME = 
	Symbol.intern("synchronize-simulation-time");

    IXAgent agent;
	
    public SyncSimulationTimeHandler(IXAgent agent) {
	super("Synchronize simulation time");
	this.agent = agent;
    }
	
    public List getSyntaxList() {
	return (LList)Lisp.readFromString
	    ("((synchronize-simulation-time ?parameter ...)))");
    }
	
    public boolean appliesTo(AgendaItem item) {
	LList pattern = item.getPattern();
	return pattern.get(0) == SYNCHRONIZE_SIMULATION_TIME;
    }

    public boolean isAutomatic() {
	return true;
    }

    public void addHandlerActions(AgendaItem item) {
	item.addAction
	    (new HandlerAction.AutomaticWhenBound(item, this));
    }
	
    public void handle(AgendaItem item) {
	Activity a = (Activity)item.getAbout();
	ISimTimer t = agent.getISimTimer();
	if (t != null)
	    t.handleSynchronizeActivity(a);
    }
	
}
