/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Fri Dec  2 17:55:29 2005 by Jeff Dalton
 * Copyright: (c) 2005, AIAI, University of Edinburgh
 */

package ix.ip2;

import ix.icore.IXAgentExtension;
import ix.iface.util.ToolController;

import ix.util.*;

/**
 * Adds an "Object Views" tool to an I-X Process Panel.
 */
public class ObjectViewExtension implements IXAgentExtension {

    private Ip2 ip2;

    public ObjectViewExtension(Ip2 ip2) {
	this.ip2 = ip2;
    }

    public void installExtension() {
	ip2.addTool(new ToolController("Object Views") {
	    public Object createTool() {
		return new ObjectWhiteboard(ip2);
	    }
	});
    }

}
