/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu Jun 19 19:19:59 2008 by Jeff Dalton
 * Copyright: (c) 2001 - 2002, 2006, 2008, AIAI, University of Edinburgh
 */

package ix.ip2;

import java.util.*;

import ix.icore.*;
import ix.icore.process.ProcessModelManager;

import ix.ip2.log.IssueHandledEvent;

import ix.util.*;
import ix.util.lisp.*;

/**
 * An agenda of issues
 */
public class IssueAgenda extends Agenda {

    public IssueAgenda(PanelController controller) {
	super(controller);
    }

    @Override
    public AgendaItem makeItem(LList pattern) {
	return new IssueItem(new Issue(pattern));
    }

    @Override
    public AgendaItem makeItem(TaskItem issue) {
	Util.mustBe(Issue.class, issue);
	return new IssueItem((Issue)issue);
    }

    @Override
    public void addItem(AgendaItem item) {
	Ip2ModelManager mm = controller.getModelManager();
        mm.beginUndoableTransaction("Add issue");
        try {
            item.setPattern(mm.putVariablesInPattern(item.getPattern()));
            // /\/: The mm.addIssue method doesn't (yet) exist.
            // However, we still have to tell the issue its model-manager
            // because it needs it for "undo".
            item.setModelManager(mm);
            // mm.addIssue(item);
            item.computeStatus();
            super.addItem(item);
        }
        finally {
            mm.endUndoableTransaction("Add issue");
        }
    }

    @Override
    public void addItemsBefore(AgendaItem at, List addList) {
	throw new UnsupportedOperationException
	    ("IssueAgenda.addItemsBefore");
    }

    @Override
    void logItemHandled(AgendaItem item, HandlerAction act) {

	// Log in the issue or activity.
	String description = act.getActionDescription();
	IssueHandledEvent event = new IssueHandledEvent();
	event.setAction(description);
	item.addHistoryEvent(event);

	// Maybe log in the agent's log as well.
	super.logItemHandled(item, act);

    }

}
