/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Tue Aug 14 15:23:34 2007 by Jeff Dalton
 * Copyright: (c) 2004 - 2007, AIAI, University of Edinburgh
 */

package ix.ip2;                 // maybe should be ix.iplan? /\/

import javax.swing.*;
import javax.swing.border.TitledBorder;

import java.awt.BorderLayout;
import java.awt.event.*;

import java.io.*;
import java.util.*;

import ix.icore.Variable;
import ix.icore.process.event.ProcessStatusEvent;

import ix.ip2.*;
import ix.ip2.event.AgendaEvent;

import ix.iplan.IPlanOptionManager;
import ix.iplan.CombinedPlanChangeListener;
import ix.iplan.event.*;

import ix.iface.util.ToolFrame;
import ix.iface.util.VerticalPanel;
import ix.iface.util.IFUtil;

import ix.util.*;
import ix.util.context.Context;	// /\/ should do the context stuff in IPlan

/**
 * ...
 */
public class IVarTool {

    Ip2 ip2;

    View view = null;

    public IVarTool(Ip2 ip2) {
	this.ip2 = ip2;
    }

    protected void setup() {
	// /\/: We delay setting up the binding-viewer until we want
	// to be visible, because the binding-viewers makes itself
	// visible when created.
       	view = new View();
 	ip2.addResetHook(new ResetHook());
 	ip2.getOptionManager().addOptionListener(new OptListener());
 	view.noteCurrentOption(ip2.getOptionManager().getOption());
	new ComboListener().connectYourself(ip2);
    }

    public void setVisible(boolean v) {
	if (view == null)
	    setup();
	view.setVisible(v);
    }

    protected class ResetHook implements Runnable {
	// Contexts have already been cleared by the time this is is called.
	public void run() {
	    Debug.noteln("Resetting", IVarTool.this);
 	    view.reset();
	}
    }

    class OptListener extends AbstractOptionListener {
	public void optionSet(OptionEvent e) {
	    view.noteCurrentOption(e.getOption());
	}
	public void optionRenamed(OptionEvent e, String oldName) {
	    if (e.getOption() == ip2.getOptionManager().getOption())
		view.noteCurrentOption(e.getOption());
	}
	public void optionContentsChanged(OptionEvent e, EventObject how) {
	    if (e.getOption() == ip2.getOptionManager().getOption())
		view.noteCurrentOption(e.getOption());
	}
    }

    class ComboListener extends CombinedPlanChangeListener {
	protected void eventReceived(EventObject e) {
	}
	// ProcessStatusListener methods
	public void newBindings(ProcessStatusEvent e, Map bindings) {
	    view.resetPossibleValues();
	}
	// AgendaListener methods
	public void itemAdded(AgendaEvent e, AgendaItem item) {
	    // See if the item adds any new variables, so that we don't
	    // reload the view for every item added.
	    if (Collect.haveCommonElements(item.getPatternVars(),
					   view.getVars()))
		    view.reloadView();
	}
	public void itemRemoved(AgendaEvent e, AgendaItem item) {
	    view.reloadView();
	}
    }

    class View extends BindingViewer {

	View() {
	    super(IVarTool.this.ip2, getAllVariables());
	}

	protected void setUpFrame() {
	    frame = new ToolFrame(ip2.getAgentDisplayName()
				  + " Variable Tool");
	    // default is equiv to setLayout(new BorderLayout());
	    frame.setJMenuBar(makeMenuBar());

	    contentPane = frame.getContentPane();
	    varPanel = new VarPanel(vars);
	
	    VerticalPanel p = new VerticalPanel();
	    p.addFixedHeight(varPanel);
	    p.add(new JPanel());          // to stretch /\/
	    JScrollPane scroll = new JScrollPane(p);
	    // /\/: Scroll tends to cover bottom of table if we put p NOTRH,
	    // so we put it CENTER but add something that will stretch below
	    // the table so that the table will stay at the top of the frame.
	    contentPane.add(scroll, BorderLayout.CENTER);

	    contentPane.add(makeButtonPanel(), BorderLayout.SOUTH);

	    frame.pack();
	    frame.setSize(400, 200);
	    frame.validate();

	}

	JMenuBar makeMenuBar() {
	    JMenuBar bar = new JMenuBar();
	    JMenu fileMenu = new JMenu("File");
	    bar.add(fileMenu);
	    fileMenu.add(IFUtil.makeMenuItem("Close", this));
	    bar.add(Box.createHorizontalStrut(300)); // force width
	    return bar;
	}

	protected ButtonPanel makeButtonPanel() {
	    return new ButtonPanel("Assign Values");
	}

	public void actionPerformed(ActionEvent e) {
	    String command = e.getActionCommand();
	    Debug.noteln("I-Var Tool action:", command);
	    if (command.equals("Assign Values"))
		bindCommand();
	    else if (command.equals("Close"))
		closeCommand();
	    else
		throw new ConsistencyException("Nothing to do for", command);
	}

	public void setVisible(Boolean v) {
	    frame.setVisible(v);
	}

	void reset() {
	    reloadView();
	}

	void noteCurrentOption(IPlanOptionManager.Opt opt) {
	    reloadView();
	    setBorderTitle(opt.getName() + " Variables");
	}

	void reloadView() {
	    reloadView(getAllVariables());
	}

	public void handleBindings(Map newBindings) {
	    bind(newBindings);
	}

	void setBorderTitle(String title) {
	    // /\/: Method copied from IPlanTool.
	    // This doesn't show the change: border.setTitle(title);
	    TitledBorder border = BorderFactory.createTitledBorder(title);
	    varPanel.setBorder(border);
	    // not needed: frame.validate();
	}

    }

    Set<Variable> getAllVariables() {
	// Make (modifiable) copy of the vars in the current context.
	return new TreeSet<Variable>
	              ((List<Variable>)Variable.getAllVariables());
    }

    Set<Variable> getAllUnboundVariables() {
	Set<Variable> result = getAllVariables();
	for (Iterator i = result.iterator(); i.hasNext();) {
	    Variable v = (Variable)i.next();
	    if (v.isBound())
		i.remove();
	}
	return result;
    }

    protected void bind(Map newBindings) {
	// /\/: As in AbstractAgendaItemPopupMenu.
	Ip2ModelManager mm = (Ip2ModelManager)ip2.getModelManager();
	try {
	    mm.bindVariables(newBindings);
	}
	catch (IllegalArgumentException e) {
	    // The user might have picked incompatible values
	    // when selecting for more than one variable.
	    Debug.displayException(e);
	}
	// If we get here ...
	mm.logBindings(newBindings);
    }

}
