/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Mon Jun 16 15:02:20 2008 by Jeff Dalton
 * Copyright: (c) 2007, 2008, AIAI, University of Edinburgh
 */

package ix.ip2;

import java.util.*;

import ix.icore.*;
import ix.icore.process.*;
import ix.icore.domain.Constraint;

import ix.util.*;
import ix.util.lisp.*;
import ix.util.match.*;
import ix.util.context.*;

public class ConstraintAssociator implements ConstraintManagerRegistry {

    protected Ip2ModelManager mm;

    protected Set<ConstraintManager> constraintManagers =
	new LinkedHashSet<ConstraintManager>();

    protected Map<Symbol, Map<Symbol, List<ConstraintManager>>> dispatchTable =
	new LinkedHashMap<Symbol, Map<Symbol, List<ConstraintManager>>>();

    public ConstraintAssociator(Ip2ModelManager mm) {
	this.mm = mm;
    }

    public void reset() {
	for (ConstraintManager m: constraintManagers) {
	    m.reset();
	}
    }

    public void clear() {
	for (ConstraintManager m: constraintManagers) {
	    m.clear();
	}
    }

    public void addConstraintManager(ConstraintManager cm,
				     Symbol type,
				     Symbol[] subtypes) {
	Debug.noteln("Registering", cm);
	constraintManagers.add(cm);
	Map<Symbol, List<ConstraintManager>> subtypeDispatch =
	    dispatchTable.get(type);
	if (subtypeDispatch == null) {
	    subtypeDispatch =
		new LinkedHashMap<Symbol, List<ConstraintManager>>();
	    dispatchTable.put(type, subtypeDispatch);
	}
	for (Symbol subtype: subtypes) {
	    List<ConstraintManager> forType = subtypeDispatch.get(subtype);
	    if (forType == null) {
		forType = new LinkedList<ConstraintManager>();
		subtypeDispatch.put(subtype, forType);
	    }
	    forType.add(cm);
	}
	// Debug.noteln("CM dispatch table:", dispatchTable);
    }

    public List<ConstraintManager> getConstraintManagers(Constraint c) {
	// Debug.noteln("CM dispatch table:", dispatchTable);
	Symbol type = c. getType();
	Symbol subtype = c.getRelation();
	Map<Symbol, List<ConstraintManager>> subtypeDispatch =
	    dispatchTable.get(type);
	Debug.noteln("Lookup " + c, subtypeDispatch);
	if (subtypeDispatch == null)
	    return null;
	return subtypeDispatch.get(subtype);
    }

    public void addConstraint(PNode node, Constraint c) {
	List<ConstraintManager> forType = getConstraintManagers(c);
	if (forType == null) {
	    Debug.noteln("Can't add " + c + " at " + node);
	    return;
	}
	for (ConstraintManager cm: forType) {
	    cm.addConstraint(node, c);
	}
    }

    public void evalAtBegin(PNodeEnd ne, Constraint c) {
	List<ConstraintManager> forType = getConstraintManagers(c);
	if (forType == null) {
	    Debug.noteln("Can't eval at begin " + c + " at " + ne);
	    return;
	}
	for (ConstraintManager cm: forType) {
	    cm.evalAtBegin(ne, c);
	}
    }

    public void evalAtEnd(PNodeEnd ne, Constraint c) {
	List<ConstraintManager> forType = getConstraintManagers(c);
	if (forType == null) {
	    Debug.noteln("Can't eval at end " + c + " at " + ne);
	    return;
	}
	for (ConstraintManager cm: forType) {
	    cm.evalAtEnd(ne, c);
	}
    }

}

// Issues:
// * Should ConstraintAssociator implement ConstraintManager?

