/* Author: Jeff Dalton
 * Updated: Sat Oct 30 21:57:52 2004 by Jeff Dalton
 * Copyright: (c) 2004, AIAI, University of Edinburgh
 */

package ix.iface.util;

import javax.swing.JPanel;
import javax.swing.JLabel;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;

import ix.util.*;

/**
 * A class that can be used to construct a vertical stack of components.
 * This class is an alternative to a vertical Box, or to a panel with
 * a Y_AXIS BoxLayout, because in some cases it has better behaviour.
 * It uses a GridBagLayout internally to control which componets can
 * grow vertically if the panel is resized.  (All are allowed to grow
 * horizontally and will normally be happy to fill the full width.)
 */
public class VerticalPanel extends JPanel {

    GridBagLayout gridbag;

    public VerticalPanel() {
	super();
	setLayout(gridbag = new GridBagLayout());
    }

    public Component add(Component comp) {
	GridBagConstraints c = new GridBagConstraints();
	c.gridx = 0;
	c.gridy = GridBagConstraints.RELATIVE;
	c.weightx = 1.0;
	c.weighty = 1.0;
	c.anchor = GridBagConstraints.NORTHWEST;
	c.fill = GridBagConstraints.BOTH;
	super.add(comp, c);
	return comp;
    }

    public Component addFixedHeight(Component comp) {
	GridBagConstraints c = new GridBagConstraints();
	c.gridx = 0;
	c.gridy = GridBagConstraints.RELATIVE;
	c.weightx = 1.0;
	c.weighty = 0.0;
	c.anchor = GridBagConstraints.NORTHWEST;
	c.fill = GridBagConstraints.HORIZONTAL;
	super.add(comp, c);
	return comp;
    }

    public Component add(Component comp, int index) {
	GridBagConstraints c = new GridBagConstraints();
	c.gridx = 0;
	c.gridy = GridBagConstraints.RELATIVE;
	c.weightx = 1.0;
	c.weighty = 1.0;
	c.anchor = GridBagConstraints.NORTHWEST;
	c.fill = GridBagConstraints.BOTH;
	gridbag.setConstraints(comp, c);
	super.add(comp, index);
	return comp;
    }

    /** Unsupported operation. */
    public void add(Component comp, Object constraints) {
	throw new UnsupportedOperationException();
    }

    /** Unsupported operation. */
    public void add(Component comp, Object constraints, int index) {
	throw new UnsupportedOperationException();
    }

    /** Unsupported operation. */
    public Component add(String name, Component comp) {
	throw new UnsupportedOperationException();
    }

}
