/* Author: Jeff Dalton
 * Updated: Wed Oct  1 04:47:11 2003 by Jeff Dalton
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 */

package ix.iface.util;

import javax.swing.JPanel;
import javax.swing.JLabel;

import java.awt.Component;
import java.awt.GridLayout;

/**
 * A class that can be used to consruct a column of a tabular display
 * in which different columns have different widths.  To make entries
 * align across rows, all columns must be made the same height by placing
 * them in something like a horizontal Box.
 */
public class GridColumn extends JPanel {

    JLabel titleLabel;
    GridLayout gridLayout;

    public GridColumn() {
	super();
	gridLayout = new GridLayout(0, 1);
	setLayout(gridLayout);
    }

    public GridColumn(String title) {
	this();
	titleLabel = new JLabel(title);
	add(titleLabel);
    }

    protected void addImpl(Component comp, Object constraints, int index) {
	gridLayout.setRows(gridLayout.getRows() + 1);
	super.addImpl(comp, constraints, index);
    }

    public void remove(int index) {
	throw new UnsupportedOperationException();
    }

    public void remove(Component comp) {
	throw new UnsupportedOperationException();
    }

    public void removeAll() {
	super.removeAll();
	gridLayout.setRows(0);
    }

    public void reset() {
	removeAll();
	if (titleLabel != null)
	    add(titleLabel);
    }

    public int getRowIndex(Component comp) {
	Component[] components = getComponents();
	for (int i = 0; i < components.length; i++) {
	    if (components[i] == comp)
		return i;
	}
	throw new Error("Can't find component " + comp);
    }

    public void replace(Component old, Component neu) {
	int row = getRowIndex(old);
	super.remove(row);
	super.addImpl(neu, null, row);
	invalidate();
    }

}
