/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Mon Jun 16 13:56:33 2008 by Jeff Dalton
 * Copyright: (c) 2005, 2006, 2008, AIAI, University of Edinburgh
 */

package ix.icore.process;

import java.util.*;

import ix.iplan.TimePointNet;	// /\/

import ix.util.Inf;
import ix.util.context.*;

public class TimePoint {

    private ContextLong __min;
    private ContextLong __max;
    private LLQueue __preCon;
    private LLQueue __postCon;

    public int tpn_mark = -1;

    public TimePoint() {
	this(0, Inf.INFINITY);
    }

    public TimePoint(long min, long max) {
	__min = new ContextLong(min);
	__max = new ContextLong(max);
	__preCon = new LLQueue();
	__postCon = new LLQueue();
    }

    public void clear(long min, long max) {
	__preCon.clear();
	__postCon.clear();
	setMinTime(min);
	setMaxTime(max);
    }

    public long getMinTime() {
	return __min.get();
    }

    public void setMinTime(long t) {
	__min.set(t);
    }

    public long getMaxTime() {
	return __max.get();
    }

    public void setMaxTime(long t) {
	__max.set(t);
    }

    public boolean hasUnboundedMax() {
	return __max.get() == Inf.INFINITY;
    }

    public List getPreConstraints() {
	return __preCon.contents();
    }

    public List getPostConstraints() {
	return __postCon.contents();
    }

    // /\/: The constraint class s.b. less specific so that we
    // don't need to know about the TimePointNet here.

    public void addPreConstraint(TimePointNet.TimeConstraint c) {
	__preCon.add(c);
    }

    public void addPostConstraint(TimePointNet.TimeConstraint c) {
	__postCon.add(c);
    }

    public void removePreConstraint(TimePointNet.TimeConstraint c) {
	__preCon.remove(c);
    }

    public void removePostConstraint(TimePointNet.TimeConstraint c) {
	__postCon.remove(c);
    }

}
