/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Mon May 21 03:56:11 2007 by Jeff Dalton
 * Copyright: (c) 2002, 2003, 2007, AIAI, University of Edinburgh
 */

package ix.icore.plan;

import java.util.*;

import ix.icore.*;
import ix.icore.domain.*;
import ix.util.*;

/**
 * Describes one level of the expansion of a {@link PlanNode}.
 */
public class PlanRefinement extends AbstractRefinement {

    protected ListOfPlanVariableDeclaration planVariableDeclarations;
    protected ListOfPlanNode planNodes;
    protected ListOfConstrainer constraints;

    public PlanRefinement() {
    }

    public ListOfPlanVariableDeclaration getPlanVariableDeclarations() {
        return planVariableDeclarations;
    }

    public void setPlanVariableDeclarations
	           (ListOfPlanVariableDeclaration planVariableDeclarations) {
        this.planVariableDeclarations = planVariableDeclarations;
    }

    public ListOfPlanNode getPlanNodes() {
        return planNodes;
    }

    public List getSubitems() {
	return getPlanNodes();
    }

    public void setPlanNodes(ListOfPlanNode planNodes) {
        this.planNodes = planNodes;
    }

    public void setSubitems(List planNodes) {
	setPlanNodes(new LinkedListOfPlanNode(planNodes));
    }

    public ListOfConstrainer getConstraints() {
        return constraints;
    }

    public void setConstraints(ListOfConstrainer constraints) {
        this.constraints = constraints;
    }

    public ListOfOrdering getOrderings() {
	return new LinkedListOfOrdering(getConstraints(Ordering.class));
    }

    public List getConstraints(Class constraintClass) {
	List result = new LinkedList();
	for (Iterator i = Collect.iterator(constraints); i.hasNext();) {
	    Object constraint = i.next();
	    if (constraintClass.isInstance(constraint))
		result.add(constraint);
	}
	return result;
    }

    // Sometimes a refinement just records constraints that were
    // not added via expansion.

    public void setIsNotExpansion() {
	setAnnotation("activity is not expanded", Boolean.TRUE);
    }

    public boolean isNotExpansion() {
	return getAnnotation("activity is not expanded") == Boolean.TRUE;
    }

}
