/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sat Aug 16 22:54:32 2003 by Jeff Dalton
 * Copyright: (c) 2002, 2003, AIAI, University of Edinburgh
 */

package ix.icore.plan;

import java.util.*;

import ix.icore.*;
import ix.util.Name;

/**
 * Describes one level of the expansion of a {@link PlanIssue}.
 */
public class PlanIssueRefinement extends AbstractRefinement {

    protected ListOfPlanVariableDeclaration planVariableDeclarations;
    protected ListOfPlanIssue planIssues;

    public PlanIssueRefinement() {
    }

    public ListOfPlanVariableDeclaration getPlanVariableDeclarations() {
        return planVariableDeclarations;
    }

    public void setPlanVariableDeclarations
	           (ListOfPlanVariableDeclaration planVariableDeclarations) {
        this.planVariableDeclarations = planVariableDeclarations;
    }

    public ListOfPlanIssue getPlanIssues() {
        return planIssues;
    }

    public List getSubitems() {
	return getPlanIssues();
    }

   public void setPlanIssues(ListOfPlanIssue planIssues) {
        this.planIssues = planIssues;
    }

    public void setSubitems(List planIssues) {
	setPlanIssues(new LinkedListOfPlanIssue(planIssues));
    }

}
