/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Wed Aug 25 15:28:53 2004 by Jeff Dalton
 * Copyright: (c) 2002, AIAI, University of Edinburgh
 */

package ix.icore.plan;

import java.util.*;

import ix.icore.*;
import ix.icore.domain.*;
import ix.util.*;
import ix.util.lisp.*;

/**
 * Represents a plan in a form that can be converted to XML, etc.
 */
public class Plan extends PlanObject {

    protected ListOfPlanVariableDeclaration planVariableDeclarations;
    protected ListOfPlanIssue planIssues;
    protected ListOfPlanIssueRefinement planIssueRefinements;
    protected ListOfPlanNode planNodes;
    protected ListOfPlanRefinement planRefinements;
    protected ListOfConstrainer constraints;
    protected ListOfPatternAssignment worldState;

    public Plan() {
    }

    public ListOfPlanVariableDeclaration getPlanVariableDeclarations() {
        return planVariableDeclarations;
    }

    public void setPlanVariableDeclarations
	           (ListOfPlanVariableDeclaration planVariableDeclarations) {
        this.planVariableDeclarations = planVariableDeclarations;
    }

    public ListOfPlanVariableDeclaration getAllPlanVariableDeclarations() {
	ListOfPlanVariableDeclaration result =
	    new LinkedListOfPlanVariableDeclaration
	        (Collect.ensureList(planVariableDeclarations));
	for (Iterator i = Collect.iterator(planRefinements);
	     i.hasNext();) {
	    PlanRefinement r = (PlanRefinement)i.next();
	    result.addAll(Collect.ensureList(r.getPlanVariableDeclarations()));
	}
	for (Iterator i = Collect.iterator(planIssueRefinements);
	     i.hasNext();) {
	    PlanIssueRefinement r = (PlanIssueRefinement)i.next();
	    result.addAll(Collect.ensureList(r.getPlanVariableDeclarations()));
	}
	return result;
    }

    public ListOfPlanIssue getPlanIssues() {
        return planIssues;
    }

    public void setPlanIssues(ListOfPlanIssue planIssues) {
        this.planIssues = planIssues;
    }

    public ListOfPlanIssueRefinement getPlanIssueRefinements() {
        return planIssueRefinements;
    }

    public void setPlanIssueRefinements
	           (ListOfPlanIssueRefinement planIssueRefinements) {
        this.planIssueRefinements = planIssueRefinements;
    }

    public PlanIssueRefinement getPlanIssueRefinement(Name id) {
        for (Iterator i = Collect.iterator(planIssueRefinements);
	     i.hasNext();) {
            PlanIssueRefinement r = (PlanIssueRefinement)i.next();
            if (r.getId().equals(id))
                return r;
        }
        throw new IllegalArgumentException
            ("No Plan Issue Refinement named " + id);
    }

   public ListOfPlanNode getPlanNodes() {
        return planNodes;
    }

    public void setPlanNodes(ListOfPlanNode planNodes) {
        this.planNodes = planNodes;
    }

    public ListOfPlanRefinement getPlanRefinements() {
        return planRefinements;
    }

    public void setPlanRefinements(ListOfPlanRefinement planRefinements) {
        this.planRefinements = planRefinements;
    }

    public PlanRefinement getPlanRefinement(Name id) {
        for (Iterator i = Collect.iterator(planRefinements); i.hasNext();) {
            PlanRefinement r = (PlanRefinement)i.next();
            if (r.getId().equals(id))
                return r;
        }
        throw new IllegalArgumentException
            ("No Plan Refinement named " + id);
    }

    public ListOfConstrainer getConstraints() {
        return constraints;
    }

    public void setConstraints(ListOfConstrainer constraints) {
        this.constraints = constraints;
    }

    public ListOfPatternAssignment getWorldState() {
        return worldState;
    }

    public void setWorldState(ListOfPatternAssignment worldState) {
        this.worldState = worldState;
    }

    public void setWorldState(Map map) {
	setWorldState(PatternAssignment.mapToAssignments(map));
    }

}

// Issues:
// * If we used a Map for the world state, the patterns (keys) would
//   by default not be output with their implementation class (LList)
//   included as an attribute on the <List>...</List> elements
//   (see the XMLTranslator class) and so would be read as LinkedLists
//   and hence cause class cast errors when something tried to use
//   them as patterns.
