/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Wed Jul  9 23:23:05 2003 by Jeff Dalton
 * Copyright: (c) 2002, 2003, AIAI, University of Edinburgh
 */

package ix.icore.plan;

import ix.icore.TaskItem;
import ix.util.Name;

/**
 * Common superclass for {@link PlanIssue} and {@link PlanNode}.
 */
public abstract class AbstractPlanItem extends PlanObject {

    protected Name id;
    protected Name expansion;

    public AbstractPlanItem() {
    }

    public Name getId() {
        return id;
    }

    public void setId(Name id) {
        this.id = id;
    }

    public Name getExpansion() {
        return expansion;
    }

    public void setExpansion(Name expansion) {
        this.expansion = expansion;
    }

    public abstract TaskItem getItem();

    public abstract void setItem(TaskItem item);

}
