/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Fri Feb  9 02:45:07 2007 by Jeff Dalton
 * Copyright: (c) 2006, 2007, AIAI, University of Edinburgh
 */

package ix.icore.domain;

import java.util.*;

import ix.util.*;
import ix.util.lisp.Symbol;

// List implementation classes:
//   LinkedListOfObjectProperty, ArrayListOfObjectProperty,

public class ObjectProperty {

    protected Symbol name;
    protected Symbol valueClassName;
    protected Syntax syntax;

    public ObjectProperty() {
        super();
    }

    public ObjectProperty(Symbol name, Symbol valClass) {
	this.name = name;
	this.valueClassName = valClass;
    }

    public ObjectProperty(Symbol name, Symbol valClass, Syntax syntax) {
	this.name = name;
	this.valueClassName = valClass;
	this.syntax = syntax;
    }

    public Symbol getName() {
        return name;
    }

    public void setName(Symbol name) {
        this.name = name;
    }

    public Symbol getValueClassName() {
        return valueClassName;
    }

    public void setValueClassName(Symbol valueClassName) {
        this.valueClassName = valueClassName;
    }

    public Syntax getSyntax() {
	return syntax;
    }

    public void setSyntax(Syntax syntax) {
	this.syntax = syntax;
    }

    public Syntax getDefaultedSyntax() {
	return getSyntax() != null
	    ? getSyntax()
	    : ObjectProperty.Syntax.DEFAULT;
    }

    public String toString() {
	return "ObjectViewProperty[" + name + ", " + syntax + "]";
    }

    public static class Syntax extends EnumeratedValue {

	private static List values = new LinkedList();

	/* package */ Syntax() { }

	private Syntax(String name) {
	    this.name = name;
	    recordValue(values, this);
	}   

	/** Value representing the type of a property value. */
	public static final Syntax
	    NUMBER = new Syntax("number"),
//  	    LONG   = new Syntax("long"),
//  	    DOUBLE = new Syntax("double"),
	    SYMBOL = new Syntax("symbol"),
	    STRING = new Syntax("string"),
	    LIST   = new Syntax("list"),
	    OBJECT = new Syntax("object");

	/** Indicates that we aren't sure of a property's type. */
	public static final Syntax DEFAULT = new Syntax("default");


	public String toString() {
	    return name;
	}

	public static List values() {
	    return Collections.unmodifiableList(values);
	}

	public static Syntax valueOf(String name) {
	    return (Syntax)getValueElseError(values, name);
	}

	public static Syntax valueOf(Symbol name) {
	    return valueOf(name.toString());
	}

    }

}
