/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Wed Feb 15 17:04:30 2006 by Jeff Dalton
 * Copyright: (c) 2006, AIAI, University of Edinburgh
 */

package ix.icore.domain;

import ix.icore.AbstractIXObject;

import ix.util.lisp.*;

public class ObjectClass extends AbstractIXObject
                         implements Named, Cloneable {

    protected String name;
    protected ListOfSymbol superClassNames;
    protected ListOfObjectProperty objectProperties;

    public ObjectClass() {
        super();
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ListOfSymbol getSuperClassNames() {
        return superClassNames;
    }

    public void setSuperClassNames(ListOfSymbol superClassNames) {
        this.superClassNames = superClassNames;
    }

    public ListOfObjectProperty getObjectProperties() {
        return objectProperties;
    }

    public void setObjectProperties(ListOfObjectProperty objectProperties) {
        this.objectProperties = objectProperties;
    }

    public Object clone() throws CloneNotSupportedException {
	return super.clone();
    }

    public String toString() {
	return "ObjectClass[" + name + "]";
    }

}

// Issues:
// * It is a major pain that the name has to be a string because
//   of the Named interface.
// * Maybe other uses of class names should also change to String
//   for now.  ListOfString and LinkedListOfString will be needed.
