/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Tue Jun 27 16:03:50 2006 by Jeff Dalton
 * Copyright: (c) 2006, AIAI, University of Edinburgh
 */

package ix.icore.domain;

import java.util.*;

import ix.util.*;
import ix.util.lisp.ItemVar;

/**
 * An exception that can be thrown when a variable, or set of variables,
 * cannot be given a value.  The variables must be {@link ItemVar}s.
 */
public class MissingValuesException extends RuntimeException {

    Set unboundVars;

    public MissingValuesException(ItemVar v) {
	super("No value was found for variable " + v);
	this.unboundVars = Collections.singleton(v);
    }

    public MissingValuesException(Set vars) {
	super("No value was found for " + Strings.disjunction(vars));
	if (!Collect.every(vars, Fn.isInstanceOf(ItemVar.class)))
	    throw new ClassCastException
		("The set " + vars + " does not contain only ItemVars.");
	this.unboundVars = vars;
    }

    public Set getUnboundVariables() {
	return unboundVars;
    }

}
