/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Wed Aug  6 16:17:13 2008 by Jeff Dalton
 * Copyright: (c) 2008, AIAI, University of Edinburgh
 */

package ix.icore.domain;

import ix.util.*;
import ix.util.reflect.HiddenFields;

/**
 * A constraint-range that can be used when the range is from the
 * 'begin' of a node to the 'end' of that same node.
 */
@HiddenFields({"from", "to"})
public class AcrossNode extends ConstraintRange {

    protected Name node;

    public AcrossNode() {
    }

    public AcrossNode(Name node) {
	super();
	setNode(node);
    }

    public Name getNode() {
	return node;
    }

    public void setNode(Name node) {
	setFrom(new NodeEndRef(End.BEGIN, node));
	setTo(new NodeEndRef(End.END, node));
	Debug.expectSame(node, this.node);
    }

    @Override
    public void setFrom(NodeEndRef from) {
	this.from = from;
	this.node = from.getNode();
    }

    @Override
    public void setTo(NodeEndRef to) {
	this.to = to;
	this.node = to.getNode();
    }

    @Override
    public String toString() {
	return "AcrossNode[" + node + "]";
    }

}
