/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Mon Jun  9 01:11:45 2008 by Jeff Dalton
 * Copyright: (c) 2002, 2004, 2007, 2008, AIAI, University of Edinburgh
 */

package ix.icore;

import java.util.*;

import ix.icore.process.PNode;
import ix.icore.process.PNodeEnd;
import ix.icore.domain.Constraint;

/**
 * Constraint Managers.
 */
public interface ConstraintManager {

    public void registerWith(ConstraintManagerRegistry r);

    public void addConstraint(PNode node, Constraint c);

    public void addConstraint(Constraint c);

    public void evalAtBegin(PNodeEnd begin, Constraint c);

    public void evalAtEnd(PNodeEnd end, Constraint c);

    public boolean mightInteract(PNodeEnd ne1, Constraint c1,
				 PNodeEnd ne2, Constraint c2);

    public void reset();

    public void clear();

}

// Issues:
// * The "add" methods used to be plural and take a list of constraints.


