/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sat Aug 27 23:17:06 2005 by Jeff Dalton
 * Copyright: (c) 2003, 2005, AIAI, University of Edinburgh
 */

package ix.rdf;

import java.util.*;

import ix.util.*;
import ix.util.rdf.*;

/**
 * A version of IPC.ObjectStreamCommunicationStrategy that encodes
 * the message contents in RDF/XML.
 */
public class RdfCommunicationStrategy
       extends IPC.SimpleIXCommunicationStrategy {

    RdfTranslator rdft = new RdfTranslator();

    public RdfCommunicationStrategy() { }

    public Object preEncode(Object contents) {
	return rdft.objectToString(contents);
    }

    public Object postDecode(Object contents) {
	Debug.noteln("Decoding", contents);
	return rdft.objectFromString((String)contents);
    }

}
