/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sat May 22 19:11:38 2004 by Jeff Dalton
 * Copyright: (c) 2004, AIAI, University of Edinburgh
 */

package ix.util.owls;

import java.util.*;

import ix.ip2.*;
import ix.icore.*;
import ix.icore.plan.*;
import ix.iplan.ServiceSymbols;
import ix.util.*;
import ix.util.xml.*;
import ix.util.lisp.*;

// N.B. In this file, Input and Output do NOT refer to the
// classes in the OWL-S API.

// /\/: The final outputs should include all outputs from
// all the steps, even if they are also used an inputs of
// other steps.  At least in some cases.

/**
 * Collects same-values lists for OWL-S process data-flow.
 */
public class ProcessDataFlow implements ServiceSymbols {

    Gensym.Generator gensym = new Gensym.Generator();

    Map objectToParametersMap = new StableHashMap();
    List sameValueLists = new LinkedList(); // contains the values from the map

    public ProcessDataFlow(List activitySequence) {
	recordSameValueLists(activitySequence);
    }

    public List getSameValueLists() {
	return sameValueLists;
    }

    void recordSameValueLists(List activitySequence) {
	for (Iterator i = activitySequence.iterator(); i.hasNext();) {
	    AgendaItem item = (AgendaItem)i.next();
	    Activity act = (Activity)item.getAbout();
	    List inputs = (List)act.getAnnotation(S_INPUTS);
	    List outputs = (List)act.getAnnotation(S_OUTPUTS);
	    if (inputs != null)
		recordParameters(act, inputs);
	    if (outputs != null)
		recordParameters(act, outputs);
	}
    }

    void recordParameters(Activity act, List parameters) {
	for (Iterator i = parameters.iterator(); i.hasNext();) {
	    ProcessParameter p = (ProcessParameter)i.next();
	    Symbol object = p.getValue();
	    List objectsParameters = (List)objectToParametersMap.get(object);
	    if (objectsParameters == null) {
		objectsParameters = new LinkedList();
		sameValueLists.add(objectsParameters);
		objectToParametersMap.put(object, objectsParameters);
	    }
	    objectsParameters.add(p.attachTo(act));
	}
    }

    // Returns a list of Inputs
    public List getInitialInputs() {
	List result = new LinkedList();
	for (Iterator i = sameValueLists.iterator(); i.hasNext();) {
	    LinkedList sameValues = (LinkedList)i.next();
	    ProcessParameter first = (ProcessParameter)sameValues.getFirst();
	    if (first.isInput()) {
		Symbol name = gensym.nextSymbol("?input_" + first.getType());
		Input in = new Input(name, first.getType(), first.getValue());
		result.add(in);
	    }
	}
	return result;
    }

    // Returns a list of Outputs
    public List getFinalOutputs() {
	List result = new LinkedList();
	for (Iterator i = sameValueLists.iterator(); i.hasNext();) {
	    LinkedList sameValues = (LinkedList)i.next();
	    ProcessParameter last = (ProcessParameter)sameValues.getLast();
	    if (last.isOutput()) {
		Symbol name = gensym.nextSymbol("?output_" + last.getType());
		Output out = new Output(name, last.getType(), last.getValue());
		result.add(out);
	    }
	}
	return result;
    }

    public List makeFullSameList(List initialInputs, List finalOutputs) {
	Map objToParam = new StableHashMap(objectToParametersMap);
	for (Iterator i = initialInputs.iterator(); i.hasNext();) {
	    Input in = (Input)i.next();
	    Symbol obj = in.getValue();
	    List sameList = (List)objToParam.get(obj);
	    LinkedList revised = new LinkedList(sameList);
	    revised.addFirst(in);
	    objToParam.put(obj, revised);
	}
	for (Iterator i = finalOutputs.iterator(); i.hasNext();) {
	    Output out = (Output)i.next();
	    Symbol obj = out.getValue();
	    List sameList = (List)objToParam.get(obj);
	    LinkedList revised = new LinkedList(sameList);
	    revised.addLast(out);
	    objToParam.put(obj, revised);
	}
	return new LinkedList(objToParam.values());
    }

}
