/****************************************************************************
 * A node renderer for list or table cells that displays <pattern> only.
 *
 * @author Jussi Stader
 * @version 1.0
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */
package ix.iview.util;

import java.util.Iterator;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JList;
import javax.swing.JLabel;
import javax.swing.ListCellRenderer;

import ix.util.Name;
import ix.util.lisp.LList;
import ix.iface.ui.*;
import ix.icore.Issue;

/****************************************************************************
 * A node renderer for list or table cells that displays <pattern> only.
 *****************************************************************************
 */
public class IssueRenderer extends IXLabelRenderer {//IXTextRenderer
  /** 
   * Creates an issue name renderer with/without a border.
   * @param isBordered - flag that determines whether to put a border around
   * the cell to show selection status
   */
  public IssueRenderer(boolean isBordered) {super(isBordered);}
  /**
   * Sets the cell text to the node number and name e.g. "[2] alter plan"
   */
  public void setInfo(Object object){
    if (object == null) setText("");
    else {
      Issue issue = (Issue)object;
      //Name name = issue.getId();
      LList pattern = issue.getPattern();;
      String text = "";
      for (Iterator i = pattern.iterator(); i.hasNext();) {
	  text = text + i.next().toString() + " ";
      }
      //text = "[" + name.toString() + "] " + text;
      setText(text);
    }
  }
}
