/****************************************************************************
 * A node renderer for list or table cells that displays "[number] elements".
 *
 * @author Jussi Stader
 * @version 1.0
 * Updated: Thu Nov  9 12:12:06 2006
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */
package ix.iview.util;

import java.util.Iterator;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JList;
import javax.swing.JLabel;
import javax.swing.ListCellRenderer;

import ix.util.Name;
import ix.util.lisp.*;
import ix.iface.ui.*;
import ix.icore.domain.NodeSpec;
import ix.iview.domain.UIRefinement;

/****************************************************************************
 * A node renderer for list or table cells that displays "[number] elements".
 *****************************************************************************
 */
public class FullNodeRenderer extends IXLabelRenderer { //IXTextRenderer
  /** 
   * Creates a node name renderer with/without a border.
   * @param isBordered - flag that determines whether to put a border around
   * the cell to show selection status
   */
  public FullNodeRenderer(boolean isBordered) {super(isBordered);}
  /**
   * Sets the cell text to the node number and name e.g. "[2] alter plan"
   */
  public void setInfo(Object object){
    if (object == null) setText("");
    else {
      String name = "";
      LList pattern = Lisp.NIL;
      if (object instanceof NodeSpec) {
	name = ((NodeSpec)object).getId().toString();
	pattern = ((NodeSpec)object).getPattern();
      }
      else if (object instanceof UIRefinement) {
	name = "self";
	pattern = new Cons(((UIRefinement)object).getName(), pattern);
      }
      String text = "";
      for (Iterator i = pattern.iterator(); i.hasNext();) {
	Object o = i.next();
	  if (o != null) text = text + o.toString() + " ";
      }
      text = "[" + name.toString() + "] " + text;
      setText(text);
    }
  }
}
