/* Author: Jussi Stader
 * @author: Jussi Stader <J.Stader@ed.ac.uk>
 * @version: 3.1
 * Updated: Thu Jul  3 13:58:24 2003
 * Copyright: (c) 2002, AIAI, University of Edinburgh
 */

package ix.iview.domain;

import java.util.*;
import javax.swing.tree.*;


import ix.util.*;
import ix.util.lisp.*;
import ix.icore.domain.*;

public class UINodeSpec extends NodeSpec implements TreeNode, Named {
  protected UIDomain uiDomain;

  public UINodeSpec(UIDomain uiDomain) {
    super();
    this.uiDomain = uiDomain;
  }
  public UINodeSpec(UIDomain uiDomain, NodeSpec original) {
    super(original.getId(), original.getPattern());
    this.uiDomain = uiDomain;
  }

  public UINodeSpec(UIDomain uiDomain, Object id, LList pattern) {
    super(id, pattern);
    this.uiDomain = uiDomain;
  }

    public Name getId() { return super.getId(); }
    public void setId(Name id) { super.setId(id); }

    public LList getPattern() { return super.getPattern(); }
    public void setPattern(LList pattern) { super.setPattern(pattern); }

  public List getNodes() {
    return new ArrayList(uiDomain.getMatchingRefinements(getPattern()));
  }

  public String getName() { return getId().toString(); }

  public Object clone() throws CloneNotSupportedException {
    return new UINodeSpec(uiDomain, getId(), getPattern());
  }

  //-----------------------TreeNode things-------------------------------------

  private static final int NOFIND = -1;
  public Enumeration children() { //one level deep only
    final List nodes = getNodes();
    return new Enumeration() {
      int i = 0;
      public boolean hasMoreElements() { return false; }
      public Object nextElement() { return null; }
      //public boolean hasMoreElements() { return i < nodes.size(); }
      //public Object nextElement() { return nodes.get(i++); }
    };
  }
  public boolean getAllowsChildren() { return false; }
  public TreeNode getChildAt(int index) { 
    return null;//dummy
  }
  public int getChildCount() { return this.getNodes().size(); }
  public int getIndex(TreeNode node) {
    return NOFIND;//dummy
  }
  public TreeNode getParent() { return null; }
  public boolean isLeaf() { return true;}

}

// Issues:


