/****************************************************************************
 * A class that holds grammar information - dummy for now.
 *
 * File: UIGrammar.java
 * @author: Jussi Stader (jussi@wiay.aiai.ed.ac.uk)
 * @version: 2.3+
 * Updated: Thu Mar 15 14:00:31 2007
 * Copyright: (c) 2002, AIAI, University of Edinburgh
 *
 ****************************************************************************
 */

package ix.iview.domain;

import java.util.*;
import ix.icore.*;
import ix.icore.domain.*;
import ix.icore.domain.event.*;
import ix.iview.domain.event.*;
import ix.util.Debug;
import ix.util.lisp.Symbol;


/** A class that holds grammar information - dummy for now.  */
public class UIGrammar extends AbstractAnnotatedObject 
implements UIDomainListener {

  /** type-rel - GenericConstraint. Describes the constraint grammar. */
  protected TreeMap genericConstraints = new TreeMap(); 
  protected UIDomain uiDomain;

  public UIGrammar(UIDomain uiDomain) {
    super();
    this.uiDomain = uiDomain;
    uiDomain.addUIDomainListener(this);
    Debug.noteln("***************making new UIGrammar");
    loadGenericConstraints(uiDomain);
  }

  /**
   * This should really come from a file.
   */
  public void initGenericConstraints() {
    genericConstraints.clear();
    //addGenericConstraint(Symbol.intern("<type>"),Symbol.intern("<relation>"),
    //			 "<parameters>");
    Symbol type = Symbol.intern("world-state");
    String form = "<pattern> = <value>";
    addGenericConstraint(type, Symbol.intern("condition"), form);
    addGenericConstraint(type, Symbol.intern("effect"), form);
    addGenericConstraint(Symbol.intern("temporal"), Symbol.intern("before"), 
			 "<node-end> <node-end>");
    addGenericConstraint(Symbol.intern("compute"),Symbol.intern("null"), form);
    addGenericConstraint(Symbol.intern("compute"), 
			 Symbol.intern("multiple-answer"), form);
  }

  public GenericConstraint addGenericConstraint(Symbol type, Symbol rel, 
						String form) {
    try {
      GenericConstraint gc = new GenericConstraint (type, rel);
      gc.setForm(form);
      genericConstraints.put(Symbol.intern(type+"-"+rel), gc);
      return gc;
    }
    catch (Exception e) { return null;}
  }
  public GenericConstraint addGenericConstraint(Constraint c) {
    if (c == null) return null;
    try {
      GenericConstraint gc = 
	  new GenericConstraint(c.getType(),c.getRelation());
      genericConstraints.put(Symbol.intern(c.getType()+"-"+c.getRelation()), 
			     gc);
      return gc;
    }
    catch (Exception e) { return null;}
  }
  public void loadGenericConstraints(UIDomain uiDomain) {
    initGenericConstraints(); //clear, then start with the known ones 
    Debug.noteln("UIGr: loading constraint grammar");
    this.uiDomain = uiDomain;
    //get all refinements. 
    List refs = uiDomain.getAllRefinements();
    if (refs == null) return;
    // For each refinement, get all constraints;
    for (Iterator ri = refs.iterator(); ri.hasNext(); ) {
      Object ro = ri.next();
      Collection constraints = null;
      if (ro instanceof Refinement) 
	constraints = ((Refinement)ro).getConstraints();
      else if (ro instanceof UIRefinement) 
	constraints = ((UIRefinement)ro).getConstraints();
      addGenericConstraints(constraints);
    }
  }

  public void addGenericConstraints(Collection constraints) {
    if (constraints != null) 
      //For each constraint: find its generic.
      for (Iterator ci = constraints.iterator(); ci.hasNext(); ) {
	Object co = ci.next();
	if (co instanceof Constraint) {
	  GenericConstraint gc = findGenericConstraint((Constraint)co);
	  // (If null, make new one into map)
	  if (gc == null) gc = addGenericConstraint((Constraint)co);
	  if ( (gc != null) && (gc.getExample() == null))
	    //generic has no example? enter this one
	    gc.setExample(((Constraint)co).getParameters());
	}
      }
  }

  public GenericConstraint findGenericConstraint(Constraint c) {
    //Debug.noteln("UIGr: looking for GC for", c);
    if (c == null) return null;
    Symbol key = Symbol.intern(c.getType()+"-"+c.getRelation());
    Object gc = genericConstraints.get(key);
    //Debug.noteln(" found", gc);
    try { return (GenericConstraint)gc; }
    catch (Exception e) { return null; }
  }

  /** Gets the list of allowed constraint patterns. This is fixed for now. */
  public List getAllConstraintPatterns(UIDomain uiDomain) {
    loadGenericConstraints(uiDomain);
    return new LinkedList(genericConstraints.values());
  }
  /** Gets the list of allowed constraint patterns. This is fixed for now. */
  public List getConstraintPatterns() {
    return new LinkedList(genericConstraints.values());
  }



  public void constructAdded(UIDomainEvent se) {
  }
  public void constructAdded(DomainEvent se) {
  }
  public void constructEdited(UIDomainEvent se) {
  }
  public void constructRemoved(UIDomainEvent se) {
  }
  public void domainCleared(UIDomainEvent se) {
    initGenericConstraints();
  }
  public void domainEdited(UIDomainEvent se) {
  }
  public void domainSet(UIDomainEvent se) {
    initGenericConstraints();
  }

}
