/****************************************************************************
 * Static class for inferring object classes from refinements
 *
 * @author Jussi Stader
 * @version 4.1
 * Updated: Thu Jan 11 09:55:04 2007
 * Copyright: (c) 2002, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */
/** Changes
 */

package ix.iview;

import ix.icore.domain.*;
import ix.iface.ui.tree.IXTrees;
import ix.iview.domain.*;
import ix.iview.util.*;
import ix.util.*;
import ix.util.lisp.*;
import java.util.*;
import javax.swing.tree.*;


/** Static class for inferring object classes from refinements */

public class ObjectClassGenerator {

  private UIDomain uiDomain;
  private UIObjectClass root;
  private int num;

  public void generateObjectClasses(UIDomain uiDomain) {
    fillObjectClasses(uiDomain);
    
  }
  /**
   *
   */
  //For each refinement,
  // find type statements and add type if needed
  //For each refinement,
  // for each variable: find type (add anonType-gen), 
  //  add property from simple cond/eff assignments to type
  public void fillObjectClasses(UIDomain uiDomain) {
    this.uiDomain = uiDomain;
    this.root = uiDomain.getObjectClassRoot();
    if (root == null) {
      root = new UIObjectClass(uiDomain, IXTrees.ROOTNAME);
      uiDomain.addConstruct(root);
    }
    num = 1;

    List refinements = uiDomain.getAllRefinements();
    if (refinements == null) return;
    
    //extract types (object classes)
    for (Iterator i = refinements.iterator(); i.hasNext(); ) {
      Object o = i.next();
      if (o == null) {} //skip null
      else if (o instanceof Refinement)
	fillTypesFromConstraints((Refinement)o);
      else if (o instanceof UIRefinement)
	fillTypesFromConstraints((UIRefinement)o);
      else Debug.noteln("OCGen: looking for refinement class, found", o);
    }

    if (root == null) uiDomain.getObjectClassRoot(); //this will collect all 
    //new classes into a new root and add child/parent links

    //extract properties of types
    for (Iterator i = refinements.iterator(); i.hasNext(); ) {
      Object o = i.next();
      if (o == null) {} //skip null
      else if (o instanceof Refinement)
	fillPropertiesFromConstraints((Refinement)o);
      else if (o instanceof UIRefinement)
	fillPropertiesFromConstraints((UIRefinement)o);
      else Debug.noteln("OCGen: looking for refinement class, found", o);
    }
    
    uiDomain.fireDomainEdited();

  }


  private void fillTypesFromConstraints(Refinement r) {
    Set vars = r.getVariablesUsed();
    List constrs = r.getConstraints();
    List conds = UIRefinement.filterForConditions(constrs);
    fillTypesFromConstraints(vars, conds);
  }
  private void fillTypesFromConstraints(UIRefinement r) {
    Set vars = r.getVariablesUsed();
    List conds = r.getConditions();
    fillTypesFromConstraints(vars, conds);
  }
  private void fillTypesFromConstraints(Set vars, List constraints) {
    if ((vars == null) || (constraints == null)) return;
    for (Iterator vi = vars.iterator(); vi.hasNext(); ) {
      Object vo = vi.next();
      if (vo instanceof ItemVar) {
	Object oType = IVUtil.findVariableClass((ItemVar)vo, constraints);
	foundType(oType);
      }
    }
  }

  private UIObjectClass foundType(Object oType) {
    if ((oType == null) || 
	(oType.toString() == null) || (oType.toString() == ""))
      return null;
    
    Object oc = uiDomain.getNamedObjectClass(oType.toString());
    if (oc != null)  //already there
      return ensureUIOC(oc);
    else {
      Debug.noteln("OCGen: foundType new oc", oType);      
      return foundObjectClass(new UIObjectClass(uiDomain, oType.toString()));
    }
  }

  private UIObjectClass foundObjectClass(UIObjectClass uioc) {
    if (uioc == null) return null;
    Object oldOc = uiDomain.getNamedObjectClass(uioc.getName());
    if (oldOc == null) {
      TreeNode parent = uioc.getParent();
      if ((parent == null) && (root != null)) {
	uioc.addParent(root);
      }
      uiDomain.addConstruct(uioc);
      return uioc;
    }
    else return ensureUIOC(oldOc);
  }

  private UIObjectClass ensureUIOC(Object oc) {
    if (oc instanceof UIObjectClass) return (UIObjectClass)oc; 
    else if (oc instanceof ObjectClass) {
      Debug.noteln("OCGen: ensuring new oc", oc);
      UIObjectClass uioc = new UIObjectClass(uiDomain, (ObjectClass)oc);
      uiDomain.addConstruct(uioc);
      return uioc;
    }
    else return null;

  }

  private void fillPropertiesFromConstraints(Refinement r) {
    Set vars = r.getVariablesUsed();
    List constrs = r.getConstraints();
    List conds = UIRefinement.filterForConditions(constrs);
    fillPropertiesFromConstraints(vars, conds);
  }
  private void fillPropertiesFromConstraints(UIRefinement r) {
    Set vars = r.getVariablesUsed();
    List conds = r.getConditions();
    fillPropertiesFromConstraints(vars, conds);
  }

  private void fillPropertiesFromConstraints(Set vars, List constraints) {
    
    if ((vars == null) || (constraints == null)) return;
    for (Iterator vi = vars.iterator(); vi.hasNext(); ) {
      Object vo = vi.next();
      String anonClass = "AnonClass" + vo.toString() + num;
      if (vo instanceof ItemVar) {
	List varConstraints = 
	  UIRefinement.filterForVariable((ItemVar)vo, constraints);
	Object oType = IVUtil.findVariableClass((ItemVar)vo, varConstraints);
	if (oType == null) {
	  oType = anonClass;
	  num += 1;
	}
	Object oc = uiDomain.getNamedObjectClass(oType.toString());
	if (oc == null) {
	  oc = foundType(oType);
	}

	UIObjectClass uioc = ensureUIOC(oc);
	if (uioc != null) { //null should not happen!
	  //now we have a type to add properties to it
	  for (Iterator ci = varConstraints.iterator(); ci.hasNext(); ) {
	    Object cn = ci.next();
	    if (cn instanceof Constraint) {
	      Constraint c = (Constraint)cn;
	      if (!IVUtil.isClassConstraint((ItemVar)vo, c)) {
		String prop = IVUtil.propertyFromConstraint(c);
		if ((prop != null) && !prop.equals("")) {
		  if (!uioc.isProperty(prop)) {
		    ObjectProperty.Syntax propType = getPropertyType(c);
		    uioc.addProperty(Symbol.intern(prop), propType);
		  }
		}
	      }
	    }
	  }
	}

	//check that some properties have been added, if not: remove anon
	if ((uioc != null) && anonClass.equals(uioc.getName())) {
	  Set props = uioc.getAllProperties();
	  if ((props == null) || props.isEmpty()) {
	    //Debug.noteln("OCGen: removing empty class", anonClass);
	    try {uiDomain.removeConstruct(uioc);}
	    catch (Exception e) {}
	  }
	}
      }
    }
  }	  

  private ObjectProperty.Syntax getPropertyType(Constraint c) {
    Object value = IVUtil.getConstraintValue(c);
    if (value != null) {
      if (value instanceof ItemVar) return ObjectProperty.Syntax.DEFAULT;
      else if (value instanceof Symbol) return ObjectProperty.Syntax.SYMBOL;
      else 
	Debug.noteln("OCGen: got value " +value.toString()+ " of class", 
		     value.getClass());
    }
    return ObjectProperty.Syntax.DEFAULT;
  }

      


}
