/****************************************************************************
 * A TableCellEditor with a combo box that can re-select the same item.
 *
 * @author Jussi Stader
 * @version 4.0+
 * Updated: Wed Nov 10 13:15:20 2004
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */
package ix.iface.ui.table;

import ix.util.*;
import ix.iface.ui.*;
import ix.iface.ui.util.*;
import ix.iface.util.*;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;
import java.util.*;


/****************************************************************************
 * A TableCellEditor with a combo box that can re-select the same item.
 *****************************************************************************
 */
public class IXDefaultCellEditor //extends DefaultCellEditor
implements FocusListener, ActionListener, PopupMenuListener,
  CellEditorListener, TableCellEditor //, ItemListener
{

  int colWidth;
  TableColumn column;
  IXEditorDelegate delegate;
  protected JComponent editorComponent;
  protected int clickCountToStart = 1;
  

  public IXDefaultCellEditor(final IXComboBox comboBox) {
    //super(comboBox);
    super();
    editorComponent = comboBox;
    comboBox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
    delegate = new IXEditorDelegate() {
      public void setValue(Object value) {
	comboBox.setSelectedItem(value);
      }

      public Object getCellEditorValue() {
	return comboBox.getSelectedItem();
      }
                
      public boolean shouldSelectCell(EventObject anEvent) { 
	//if (!(anEvent instanceof MouseEvent) || 
	//    !(((MouseEvent)anEvent).getID() != MouseEvent.MOUSE_DRAGGED))
	//  Debug.noteln("IXDCE: got event", anEvent);
	if (anEvent instanceof MouseEvent) { 
	  MouseEvent e = (MouseEvent)anEvent;
	  return e.getID() != MouseEvent.MOUSE_DRAGGED;
	}
	return true;
      }
      public boolean stopCellEditing() {
	if (comboBox.isEditable()) {
	  // Commit edited value.
	  comboBox.
	    actionPerformed(new ActionEvent(IXDefaultCellEditor.this, 0, ""));
	}
	return super.stopCellEditing();
      }
    };
    comboBox.addActionListener(new CatchingActionListener(delegate));
    comboBox.setEditable(false);
    UIUtil.listenToCB(comboBox, this);
    ListCellRenderer lcr = comboBox.getRenderer();
    if (lcr == null) comboBox.setRenderer(new NDRenderer(false));
    comboBox.getEditor().addActionListener(new CatchingActionListener(this));
    this.addCellEditorListener(this);
  }

  /**
   * Overwrite this with your own initialisation if needed, then call this as
   * the last thing you do.
   * See HandlerActionEditor for an example.
   */
  public Component getTableCellEditorComponent(JTable table, Object value,
					       boolean isSelected,
					       int row, int column) {
    //Debug.noteln("IXDCE: getting component");
    try {
      IXComboBox jcb = (IXComboBox)editorComponent;
      //just clear the selected item so that re-selecting the same item goes ok
      jcb.clearSelectedItem();
      //adjustWidth(jcb, table, column);
    } catch (ClassCastException cce) {}      
    return editorComponent;
  }

  public void adjustWidth(IXComboBox jcb, JTable table, int col) {
    Debug.noteln("IXDCE: adjusting width");
    column = table.getColumnModel().getColumn(col);
    colWidth = column.getPreferredWidth();
    int longest = 0;
    String longestS = "";
    //get the longest thing
    for (int i=0; i < jcb.getItemCount(); i++) {
      String s = jcb.getItemAt(i).toString();
      if (longest < s.length()) {
	longest = s.length();
	longestS = s;
      }
    }
    int longestW = jcb.getFontMetrics(jcb.getFont()).stringWidth(longestS);
    int currentWidth = jcb.getPreferredSize().width;
    Debug.noteln(" current width", currentWidth);
    int height = jcb.getPreferredSize().height;
    int newWidth = Math.max(longestW, currentWidth);
    Dimension d = new Dimension(newWidth, height);
    Debug.noteln(" new dimension:", d.toString());
    jcb.setBounds(jcb.getX(), jcb.getY(), newWidth, height);
    //jcb.setPreferredSize(d);
    //jcb.setMinimumSize(d);
    //column.setPreferredWidth(newWidth);
  }



    public Component getComponent() {
	return editorComponent;
    }
    public void setClickCountToStart(int count) {
	clickCountToStart = count;
    }
    public int getClickCountToStart() {
	return clickCountToStart;
    }


//
//  Implementing the CellEditor Interface
//

    // implements javax.swing.CellEditor
    public Object getCellEditorValue() {
        return delegate.getCellEditorValue();
    }

    // implements javax.swing.CellEditor
    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) { 
            return ((MouseEvent)anEvent).getClickCount() >= clickCountToStart;
        }
    	return true;
    }
    
    // implements javax.swing.CellEditor
    public boolean shouldSelectCell(EventObject anEvent) { 
	return delegate.shouldSelectCell(anEvent); 
    }

    // implements javax.swing.CellEditor
    public boolean stopCellEditing() {
	fireEditingStopped();
    	return true;
    }

    // implements javax.swing.CellEditor
    public void cancelCellEditing() {
	fireEditingCanceled();
    }



  /*
  public Object getCellEditorValue() {
    //Debug.noteln("***HAE: getting cell editor value");
    JComboBox jcb = (JComboBox)editorComponent;
    Object newItem;
    if (jcb.isEditable()) {
      newItem =  jcb.getEditor().getItem();
    } else {
      newItem= jcb.getSelectedItem();
    }
    Debug.noteln(" cell editor value is", newItem.toString());
    return newItem;
  }
  */

  public void focusGained(FocusEvent fe) {}
  public void focusLost(FocusEvent fe) {
    Debug.noteln("***IXDE: Losing focus");
    stopCellEditing();
  }



  public void actionPerformed(ActionEvent e) {
    //Debug.noteln("***IXDE: performed action", e.paramString());
  }

  

  public void popupMenuCanceled(PopupMenuEvent pme) {
    Debug.noteln("IXDCE: canceling");
    cancelCellEditing();
    //fireCellEditingCanceled();
  }
  public void popupMenuWillBecomeVisible(PopupMenuEvent pme) {
  }
  public void popupMenuWillBecomeInvisible(PopupMenuEvent pme) {
    Debug.noteln("IXDCE: stopping");
    stopCellEditing();
    //fireCellEditingStopped();
  }

  public void editingCanceled(ChangeEvent e) {
    if (column != null) column.setPreferredWidth(colWidth);
  }
  public void editingStopped(ChangeEvent e) {
    if (column != null) column.setPreferredWidth(colWidth);
  }


//
//  Protected IXEditorDelegate class
//

  protected class IXEditorDelegate implements ActionListener, ItemListener {

        /** Not implemented. */
        protected Object value;
        /** Not implemented. */
        public Object getCellEditorValue() {
            return null;
        }

        /** Not implemented. */
        public void setValue(Object x) {}

        /** Not implemented. */
        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }
    
        /** Unfortunately, restrictions on API changes force us to 
          * declare this method package private. 
          */
        boolean shouldSelectCell(EventObject anEvent) { 
            return true; 
        }


        /** Not implemented. */
        public boolean startCellEditing(EventObject anEvent) {
            return true;
        }

        /** Not implemented. */
        public boolean stopCellEditing() {
            return true;
        }

        /** Not implemented. */
       public void cancelCellEditing() {
       }

        // Implementing ActionListener interface
        public void actionPerformed(ActionEvent e) {
	  fireEditingStopped();
        }

        // Implementing ItemListener interface
        public void itemStateChanged(ItemEvent e) {
	  fireEditingStopped();
        }
    }


//
//  Handle the event listener bookkeeping
//

  HashSet listeners = new HashSet();
  transient protected ChangeEvent changeEvent = null;

  public void addCellEditorListener(CellEditorListener l) {
    listeners.add(l);
  }

  public void removeCellEditorListener(CellEditorListener l) {
    listeners.remove(l);
  }

  /*
   * Notify all listeners that have registered interest for
   * notification on this event type.
   */
  protected synchronized void fireEditingStopped() {
    for (Iterator i = listeners.iterator(); i.hasNext(); ) {
      if (changeEvent == null) changeEvent = new ChangeEvent(this);
      ((CellEditorListener)i.next()).editingStopped(changeEvent);
    }	       
  }


  /*
   * Notify all listeners that have registered interest for
   * notification on this event type.
   */
  protected synchronized void fireEditingCanceled() {
    for (Iterator i = listeners.iterator(); i.hasNext(); ) {
      if (changeEvent == null) changeEvent = new ChangeEvent(this);
      ((CellEditorListener)i.next()).editingCanceled(changeEvent);
    }	
  }       
    

}

  
