/* Author: Jussi Stader <J.Stader@ed.ac.uk>
 * Updated: Mon Jan  9 16:29:43 2006
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 */

package ix.iface.ui;
import javax.swing.*;

/**
 * An interface implemented by all applications (agents) that have
 * properties or preferences that can be changed.
 */
public interface PropertiesApplication {
  /** Sets the given property within the application to the given value. */
  public void setProperty(String which, String value);
  /** Gets the current setting of the given property from the application. */
  public String getProperty(String which);
  /** 
   * @return the name of the application.
   * Used to get default properties file name.
   */
  public String getName();
  /** 
   * @return the frame of the application.
   * Used to link the dialogue to the frame
   */
  public JFrame getFrame();
}

// Issues:
