/****************************************************************************
 * A renderer for named objects.
 *
 * @author Jussi Stader
 * @version 3.1
 * Updated: Mon Jun  5 10:49:35 2006
 * Copyright: (c) 2002, AIAI, University of Edinburgh
 */

package ix.iface.ui;

import ix.icore.*;
import ix.util.Debug;
import ix.icore.domain.*;
import javax.swing.*;
import java.util.*;

/**
 * An efficient renderer like RendererJLabel, but a subclass of JTextField
 * to allow mousing text. The text field is non-editable.
 */
public class NamedRenderer extends IXLabelRenderer {

  public NamedRenderer() { //setEditable(false);
    super(false);
  }
  public NamedRenderer(boolean isBordered) { //setEditable(false);
    super(isBordered);
  }

  public void setInfo(Object object) {
    //Debug.noteln("NRend: setting object", object);
    if (object == null) setText("");
    else if (object instanceof Named)
      setText(((Named)object).getName());
    else if (object instanceof ObjectProperty)
      setText(((ObjectProperty)object).getName().toString());
    else setText(object.toString());
  }


}

 
