/****************************************************************************
 * NDRenderer - uses text, colour, image and a symbol to display information.
 * 
 * @author Jussi Stader
 * @version 1.0
 */
package ix.iface.ui;

import ix.util.*;

import java.awt.Color;
import javax.swing.Icon;
import javax.swing.ImageIcon;


/****************************************************************************
 * NDRenderer - uses text, colour, image and a symbol to display information.
 * 
 * A NDRenderer can be used for table cells and list cells.
 * It expects to use a TwoField, ThreeField or FourField object to obtain up
 * to four values, which are represented using text, colour, an image and a 
 * symbol 
 * The cell can have a border to reflect whether the cell is selected when 
 * the cell has a background colour.
 * The border is used to show whether the cell/row is selected or not.
 * Borders are managed by the IXRenderer.
 *
 ****************************************************************************
 */
public class NDTextRenderer extends IXTextRenderer { 
  /** 
   * Makes a label with or without a border.
   * If colour is used, the border can reflect whether the cell is selected.
   * @param isBordered determines whether the cell has a border or not.
   */
  public NDTextRenderer(boolean isBordered) {super(isBordered);}

    
  public void setInfo(Object object) {
    if (object == null) {
      Debug.noteln("NDTextRenderer: cannot render null values!");
      return;
    }
    //Turn the object into a four-field one to get at its components
    FourField fourField = (FourField) object;
    //For each 4 components - get and set it, if there is one
    //---colour
    if (fourField.hasColour() && (fourField.toColour() != null)) 
      this.setBackground(fourField.toColour());
    //--- symbol and string
    String fieldString = fourField.toString();
    if (fourField.hasSymbol() 
	&& (fourField.toSymbol() != null))
      this.setText((String) fieldString + " " + fourField.toSymbol());
    else this.setText((String)fieldString);
    //--- icon
    if (fourField.hasIcon() && (fourField.toIcon() != null))
      Debug.noteln("NDTextRenderer cannot render icon", fourField.toIcon());
  }

}

