/****************************************************************************
 * A simple panel with a label, a component, and optional buttons.
 *
 * @author Jussi Stader
 * @version 1.0
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 *
 *****************************************************************************
 */
package ix.iface.ui;

import java.awt.BorderLayout;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.*;
import javax.swing.border.TitledBorder;
import javax.swing.text.JTextComponent;
import javax.swing.table.*;

import ix.util.Debug;
import ix.iface.ui.table.*;
    
/**
 * A simple panel with a label (title), a component, and optional buttons.
 * The given label will be at the top, the given component at the left and
 * buttons with given labels on the right.
 * Adds the given listener to the buttons and the list.
 */
public interface IXEditorPanel {
  /** Sets the panel's label */
  public void setLabel(String label);

  /** Gets the panel's name */
  public String getName();

  /** Gets the panel's item component */
  public JComponent getItemComponent();

  /**
   * Gets the current data of the panel's item component.
   * @return an array of objects that are the current data model of the list
   */
  public Object getData();

  /**
   * Sets the current data of the item component.
   * @param data an object that is to be put into the item component
   * NOTE: this should call dataSet(data) when it's done
   */
  public void setData(Object data);

  /** Removes all data from the item component */
  public void removeData();

  /**
   * Checks whether the item component can take lists (e.g. JList/JComboBox)
   */
  public boolean isListItem();

  /**
   * Sets the renderer if the itemComponent is a JList or a JComboBox;
   * @return true if the renderer was set, false if not.
   */
  public boolean setRenderer(ListCellRenderer r);

  /**
   * Makes the item editable or not (default is editable).
   */
  public void setEnabled(boolean isEditable);

  public void minimise();
  public void deMinimise();
  public boolean isMinimised();

  public void larger();
  public void smaller();
  //public void hide();
}
