/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu Sep  4 13:51:10 2008 by Jeff Dalton
 * Copyright: (c) 2007, 2008, AIAI, University of Edinburgh
 */

package ix.util.http;

import java.io.IOException;

/**
 * Indicates that an HTTP request should return a given error status
 * and reason.
 */
public class HttpRequestException extends IOException {

    private int status;
    private String reason;

    public HttpRequestException(int status, String reason) {
	super("HTTP request returned " + status + ": " + reason);
	this.status = status;
	this.reason = reason;
    }

    public int getStatus() {
	return status;
    }

    public String getReason() {
	return reason;
    }

}
