/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu Jul 16 18:34:20 2009 by Jeff Dalton
 * Copyright: (c) 2009, AIAI, University of Edinburgh
 */

package ix.iserve.ipc;

import java.io.Serializable;

import ix.util.*;

/**
 * Registration response received by an {@link IServeCommStrategy}.
 */
public class Registration implements Serializable {

    protected String status; // "OK" or failure reason
    protected String uuid;

    public Registration() {
    }

    public static Registration makeSuccess(String uuid) {
        Registration r = new Registration();
        r.status = "OK";
        r.uuid = uuid;
        return r;
    }

    public static Registration makeFailure(String status) {
        Debug.expect(!status.equals("OK"));
        Registration r = new Registration();
        r.status = status;
        r.uuid = null;
        return r;
    }

    public String getStatus() {
	return status;
    }

    public void setStatus(String status) {
	this.status = status;
    }

    public String getUUID() {
        return uuid;
    }

    public void setUUID(String uuid) {
        this.uuid = uuid;
    }

    public String getUuid() {   // makes XML translator happy /\/
        return uuid;
    }

    public void setUuid(String uuid) {   // makes XML translator happy /\/
        this.uuid = uuid;
    }

    public boolean isSuccess() {
        return status.equals("OK");
    }

}
