/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Tue Jul 14 17:43:48 2009 by Jeff Dalton
 * Copyright: (c) 2003, 2007 - 2009, AIAI, University of Edinburgh
 */

package ix.iserve.ipc;

import java.util.*;

import ix.util.*;

public class MessageMemory implements Iterable<MessageWrapper> {

    protected final SortedMap<Integer,MessageWrapper> seqNoToMessageMap =
        new TreeMap<Integer,MessageWrapper>();

    public MessageMemory() { }

    public int size() {
	return seqNoToMessageMap.size();
    }

    public boolean isEmpty() {
        return seqNoToMessageMap.isEmpty();
    }

    public void clear() {
        seqNoToMessageMap.clear();
    }

    public void remember(MessageWrapper m) {
	Integer i = m.getSequenceNumber();
	Debug.expect(!seqNoToMessageMap.containsKey(i));
	seqNoToMessageMap.put(i, m);
    }

    public void forget(MessageWrapper m) {
	forgetKey(m.getSequenceNumber());
    }

    public void forgetKey(Integer key) {
	Debug.expect(seqNoToMessageMap.containsKey(key));
	seqNoToMessageMap.remove(key);
    }

    public boolean containsKey(Object key) {
	return seqNoToMessageMap.containsKey(key);
    }

    public MessageWrapper getMessage(Integer key) {
        return seqNoToMessageMap.get(key);
    }

    public Integer firstKey() {
	return seqNoToMessageMap.firstKey();
    }

    public Integer lastKey() {
	return seqNoToMessageMap.lastKey();
    }

    public MessageWrapper getFirstRemainingMessage() {
	return seqNoToMessageMap.isEmpty()
	    ? null
	    : seqNoToMessageMap.get(seqNoToMessageMap.firstKey());
    }

    public void renumberMessages(int delta) {
        List<MessageWrapper> entries =
            new ArrayList<MessageWrapper>(seqNoToMessageMap.values());
        seqNoToMessageMap.clear();
        for (MessageWrapper m: entries) {
            int mSeq = m.getSeqNo();
            int toSeq = mSeq + delta;
            Debug.noteln("renumbering " + mSeq + " to " + toSeq);
            m.setSeqNo(toSeq);
            remember(m);
        }
    }

    public void walkContents(Proc p) {
	for (Map.Entry<Integer,MessageWrapper> e:
                 seqNoToMessageMap.entrySet()) {
	    p.call(e.getKey(), e.getValue());
	}
    }

    public Iterator<MessageWrapper> iterator() {
        return seqNoToMessageMap.values().iterator();
    }

}
