/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.owls.process.execution.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mindswap.owls.OWLSFactory;
import org.mindswap.owls.process.AtomicProcess;
import org.mindswap.owls.process.CompositeProcess;
import org.mindswap.owls.process.ControlConstruct;
import org.mindswap.owls.process.DataFlow;
import org.mindswap.owls.process.Process;
import org.mindswap.owls.process.ProcessComponentList;
import org.mindswap.owls.process.Sequence;
import org.mindswap.owls.process.Split;
import org.mindswap.owls.process.SplitJoin;
import org.mindswap.owls.process.Unordered;
import org.mindswap.owls.process.ValueMap;
import org.mindswap.owls.process.execution.ProcessExecutionEngine;
import org.mindswap.owls.process.execution.ProcessExecutionListener;

public class ProcessExecutionEngineImpl
implements ProcessExecutionEngine {
    protected List executionListeners = new ArrayList();

    public void notifyListeners(String msg) {
        Iterator i = this.executionListeners.iterator();
        while (i.hasNext()) {
            ProcessExecutionListener l = (ProcessExecutionListener)i.next();
            l.printMessage(msg);
        }
    }

    public void setCurrentExecuteService(Process p) {
        Iterator i = this.executionListeners.iterator();
        while (i.hasNext()) {
            ProcessExecutionListener l = (ProcessExecutionListener)i.next();
            l.setCurrentExecuteService(p);
        }
    }

    public void finishExecution(int retCode) {
        Iterator i = this.executionListeners.iterator();
        while (i.hasNext()) {
            ProcessExecutionListener l = (ProcessExecutionListener)i.next();
            l.finishExecution(retCode);
        }
    }

    public void addExecutionListener(ProcessExecutionListener listener) {
        this.executionListeners.add(listener);
    }

    public ValueMap execute(Process p) {
        return this.execute(p, OWLSFactory.createValueMap());
    }

    public ValueMap execute(Process p, ValueMap values) {
        return this.executeInternal(p, values);
    }

    private ValueMap executeInternal(Process p, ValueMap values) {
        ValueMap result = this.execute(p, values, OWLSFactory.createDataFlow());
        if (result != null) {
            this.finishExecution(-1);
        }
        return result;
    }

    private ValueMap execute(Process p, ValueMap values, DataFlow dataFlow) {
        ValueMap valueMap = null;
        if (p instanceof AtomicProcess) {
            valueMap = this.executeAtomic((AtomicProcess)p, values);
        } else if (p instanceof CompositeProcess) {
            dataFlow.addAll(p.getDataFlow());
            valueMap = this.executeConstruct(((CompositeProcess)p).getComposedOf(), values, dataFlow);
        }
        return valueMap;
    }

    private ValueMap executeAtomic(AtomicProcess p, ValueMap values) {
        try {
            ValueMap valueMap = OWLSFactory.createValueMap();
            valueMap.addMap(p.getDefaultValues());
            valueMap.addMap(values);
            valueMap = p.getGrounding().invoke(valueMap);
            return valueMap;
        }
        catch (Exception e) {
            System.out.println("ERROR: cannot invoke atomic process " + p.getLabel());
            System.out.println("Exception: " + e);
            e.printStackTrace();
            return null;
        }
    }

    private ValueMap executeConstruct(ControlConstruct c, ValueMap values, DataFlow dataFlow) {
        if (c instanceof Sequence) {
            return this.executeOrdered(c, values, dataFlow);
        }
        if (c instanceof Unordered) {
            return this.executeOrdered(c, values, dataFlow);
        }
        if (c instanceof Split) {
            return this.executeParallel(c, values, dataFlow, false);
        }
        if (c instanceof SplitJoin) {
            return this.executeParallel(c, values, dataFlow, true);
        }
        return null;
    }

    private ValueMap executeOrdered(ControlConstruct s, ValueMap values, DataFlow dataFlow) {
        ValueMap allValues = OWLSFactory.createValueMap();
        allValues.addMap(values);
        ProcessComponentList processList = s.getComponents();
        this.notifyListeners("Start execution (# of processes " + processList.size() + ")\n");
        int i = 0;
        while (i < processList.size()) {
            boolean success;
            Process process = (Process)processList.get(i);
            this.setCurrentExecuteService(process);
            System.out.println("Execute sub-process " + i + " " + process);
            this.notifyListeners("\tExecute sub-process " + (i + 1) + " - " + process.getLabel() + "\n");
            DataFlow df = OWLSFactory.createDataFlow();
            df.addAll(dataFlow);
            df.addAll(s.getDataFlow());
            ValueMap result = this.execute(process, allValues, df);
            boolean bl = success = result != null;
            if (!success) {
                this.notifyListeners("[ERROR]\n");
                this.notifyListeners("Execution Stopped\n");
                this.finishExecution(-2);
                return null;
            }
            allValues.addMap(result);
            allValues.applyDataFlow(df);
            this.notifyListeners("\t[DONE]\n");
            ++i;
        }
        this.notifyListeners("Execution completed\n");
        return allValues;
    }

    private ValueMap executeParallel(ControlConstruct s, ValueMap values, DataFlow dataFlow, boolean join) {
        ValueMap allValues = OWLSFactory.createValueMap();
        allValues.addMap(values);
        ProcessComponentList processList = s.getComponents();
        ProcessExecutionThread[] threads = new ProcessExecutionThread[processList.size()];
        this.notifyListeners("Start execution (# of processes " + processList.size() + ")\n");
        int i = 0;
        while (i < processList.size()) {
            DataFlow df = OWLSFactory.createDataFlow();
            df.addAll(dataFlow);
            df.addAll(s.getDataFlow());
            Process process = (Process)processList.get(i);
            threads[i] = new ProcessExecutionThread(process, allValues);
            this.setCurrentExecuteService(process);
            threads[i].run();
            ++i;
        }
        if (join) {
            i = 0;
            while (i < processList.size()) {
                try {
                    threads[i].join();
                }
                catch (InterruptedException e) {
                    this.notifyListeners("[ERROR]\n");
                    this.notifyListeners("Execution Stopped\n");
                    this.finishExecution(-2);
                    return null;
                }
                ++i;
            }
        }
        this.notifyListeners("Execution completed\n");
        return allValues;
    }

    class ProcessExecutionThread
    extends Thread {
        Process process;
        ValueMap values;
        ValueMap result;

        ProcessExecutionThread(Process process, ValueMap values) {
            this.process = process;
            this.values = values;
        }

        public void run() {
            this.result = ProcessExecutionEngineImpl.this.execute(this.process, this.values);
        }

        public boolean isSuccess() {
            return this.result != null;
        }

        public ValueMap getResult() {
            return this.result;
        }
    }
}

