/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.owls.io.impl;

import java.io.IOException;
import java.io.Writer;
import org.mindswap.owls.OWLSFactory;
import org.mindswap.owls.io.OWLSWriter;
import org.mindswap.owls.io.impl.OWLSWriterImpl;
import org.mindswap.owls.service.Service;

public class GenericOWLSWriter
extends OWLSWriterImpl {
    public static boolean DEBUG = false;

    public GenericOWLSWriter() {
        this.version = "X.X";
    }

    public void write(Service service, Writer out) throws IOException {
        String serviceVersion = service.getOWLSVersion();
        OWLSWriter writer = null;
        if (serviceVersion == null) {
            System.err.println("Warning: No OWL-S version in service " + service);
        } else if (OWLSFactory.getSupportedVersions().contains(serviceVersion)) {
            writer = OWLSFactory.createOWLSWriter(serviceVersion);
        } else {
            System.err.println("Warning: Unrecognized OWL-S version " + serviceVersion + " for service " + service);
        }
        if (writer == null) {
            writer = OWLSFactory.createOWLSWriter(OWLSFactory.getLatestVersion());
        }
        writer.write(service, out);
    }
}

