/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermFactory;
import aterm.ATermList;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import com.lre.utils.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.ATermUtils;
import org.mindswap.pellet.Classify;
import org.mindswap.pellet.OWLParser;
import org.mindswap.pellet.OWLReasoner;
import org.mindswap.pellet.OWLTest;
import org.mindswap.pellet.OutputFormatter;
import org.mindswap.pellet.Pellet;
import org.mindswap.pellet.Query;
import org.mindswap.pellet.TBox;
import org.mindswap.pellet.TermDefinition;
import org.mindswap.pellet.TuBox;

public class Test {
    private static ATermFactory factory = ATermUtils.getFactory();

    public static final void main(String[] args) throws Exception {
        Test test = new Test();
        String base = OWLTest.USE_CACHE ? "file://C/Mindswap/owl-test/" : "http://www.w3.org/2002/03owlt/";
        test.testPellet();
    }

    public void testRules() throws Exception {
        ABox.DEBUG = false;
        OWLReasoner.DEBUG = false;
        String onto = "family";
        String input = Pellet.toURI(String.valueOf(onto) + ".owl");
        String rules = Pellet.toURI(String.valueOf(onto) + "Rules.owl");
        String conc = Pellet.toURI(String.valueOf(onto) + "Conclusions.owl");
        OWLReasoner reasoner = new OWLReasoner();
        reasoner.loadOntology(input);
        reasoner.loadRules(rules);
        reasoner.checkConsistency();
        System.out.println("****** Consistent " + reasoner.isConsistent());
        System.out.println("****** Entailment started");
        System.out.println("****** Entailed " + reasoner.isEntailed(conc));
        OutputFormatter out = new OutputFormatter(false);
        Classify c = new Classify(reasoner);
        c.print(out, 0);
        c.printStats();
        System.out.println();
    }

    public void doTest() {
        String file = "";
        file = "description-logic/Manifest667";
        OWLReasoner.DEBUG = true;
        OWLParser.DEBUG = false;
        ABox.DEBUG = false;
        ABox.USE_CLONING = false;
        OWLTest.timeout = 1000000;
        OWLTest.SHOW_STATS = 0;
        OWLParser.USE_LOCAL_NAME = true;
        OWLParser.PRINT_SIZE = true;
        ABox.USE_SEMANTIC_BRANCHING = true;
        ABox.USE_BACKJUMPING = true;
        OWLParser.MAX_CARD_VALUE = 10000;
        OWLParser.NO_ANON_CLASSES = true;
        String base = OWLTest.USE_CACHE ? "file://C/Mindswap/owl-test/" : "http://www.w3.org/2002/03owlt/";
        file = String.valueOf(base) + file;
        if (OWLTest.USE_CACHE) {
            file = String.valueOf(file) + ".rdf";
        }
        OWLTest test = new OWLTest();
        test.doTest(file);
    }

    public void testFile() throws Exception {
        String file = "http://www.mindswap.org/~bparsia/ontologies/sws/iope-exp.owl";
        file = "galen.owl";
        file = "terrorism.owl";
        file = Pellet.toURI(file);
        System.out.println("Reading file " + file);
        long time = System.currentTimeMillis();
        OWLParser.DEBUG = false;
        ABox.DEBUG = true;
        ABox.USE_SEMANTIC_BRANCHING = true;
        ABox.USE_BACKJUMPING = true;
        ABox.USE_ABSORPTION = true;
        Classify.DEBUG = true;
        OWLParser.THROW_UNSUPPORTED_EXCEPTIONS = false;
        OWLParser.PRINT_SIZE = true;
        OWLParser.NO_ANON_CLASSES = true;
        OWLParser.USE_LOCAL_NAME = true;
        Pellet.timers.startTimer("totalTime");
        OWLReasoner reasoner = new OWLReasoner();
        reasoner.loadOntology(file);
        Iterator i = reasoner.getABox().tbox.classes.iterator();
        while (i.hasNext()) {
            ATermAppl c = ATermUtils.makeTermAppl("tambis-full:phosphorus");
            c = (ATerm)i.next();
            System.out.print("Concept: " + c + "...");
            System.out.flush();
            ATermAppl u = reasoner.getABox().tbox.Tu.unfoldTerm(c);
            System.out.println(u);
            System.out.print("1.");
            ATerm n = ATermUtils.normalize((ATerm)u);
            System.out.print("2.");
            TermDefinition td = reasoner.getABox().tbox.Tu.getTD((ATerm)c);
            ATermList l = td == null || td.sub == null ? ATermUtils.makeList() : td.sub.getArgument(1);
            System.out.print("3.");
            ATerm t = ATermUtils.normalize((ATerm)l);
            System.out.println("4.");
            System.out.println(n);
        }
    }

    public void testPellet() throws Exception {
        String file = "http://protege.stanford.edu/plugins/owl/owl-library/mad_cows.owl";
        file = "http://www.cs.man.ac.uk/~horrocks/OWL/Ontologies/mad_cows.owl";
        file = "drs2.rdf";
        file = "http://www.flacp.fujitsulabs.com/tce/SE/FLACP-ProjectOnt.owl";
        OWLParser.DEBUG = false;
        OWLReasoner.DEBUG = true;
        Classify.DEBUG = true;
        ABox.DEBUG = false;
        ABox.CHECK_DATATYPE_COUNT = false;
        ABox.USE_SEMANTIC_BRANCHING = true;
        ABox.USE_BACKJUMPING = true;
        OWLParser.THROW_UNSUPPORTED_EXCEPTIONS = false;
        OWLParser.PRINT_SIZE = !OWLParser.DEBUG;
        OWLParser.NO_ANON_CLASSES = true;
        ABox.USE_CACHING = true;
        OWLParser.USE_LOCAL_NAME = false;
        Classify.showFullURIs = true;
        Pellet.DEBUG = true;
        ABox.USE_CLONING = false;
        Pellet pellet = new Pellet();
        pellet.setInFile(Pellet.toURI(file));
        pellet.setTimeout(1000);
        pellet.setClassifyFormat("tree");
        pellet.setRealize(true);
        pellet.run();
        System.out.println(Pellet.getTimeInfo(true));
    }

    public void testDLized() throws Exception {
        Vector files = this.listFiles(new File("DLized"));
        int i = 0;
        while (i < files.size()) {
            File f = (File)files.get(i);
            OWLReasoner reasoner = new OWLReasoner();
            reasoner.loadOntology(new FileInputStream(f));
            String url1 = "http://www.mindswap.org/~evren/DLized/" + f.getParentFile().getName().toLowerCase() + "/" + f.getName();
            String url2 = "http://phoebus.cs.man.ac.uk:9999/OWL/Validator?url=" + URLEncoder.encode(url1, "ISO-8859-1") + "&level=DL&abstract=yes";
            String s = "<strong>DL</strong>: <span class=\"no\">NO</span>";
            BufferedReader in = new BufferedReader(new InputStreamReader(new URL(url2).openStream()));
            String line = in.readLine();
            boolean no = false;
            while (line != null) {
                if (line.indexOf(s) != -1) {
                    System.out.println("No " + url1);
                    no = true;
                    break;
                }
                line = in.readLine();
            }
            if (!no) {
                System.out.println("Yes " + url1);
            }
            ++i;
        }
    }

    Vector listFiles(File root) {
        if (root.isFile()) {
            return null;
        }
        Vector<File> result = new Vector<File>();
        File[] files = root.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                result.addAll(this.listFiles(files[i]));
            } else {
                result.add(files[i]);
            }
            ++i;
        }
        return result;
    }

    public void testNNF() {
        ATerm a = ATermUtils.nnf(factory.parse("not(and(p,c))"));
        ATermUtils.assertTrue(a.equals((Object)factory.parse("or(not(p),not(c)))")));
        a = ATermUtils.nnf(factory.parse("not(all(p,c))"));
        ATermUtils.assertTrue(a.equals((Object)factory.parse("some(p,not(c)))")));
        a = ATermUtils.nnf(factory.parse("all(p,not(or(not(c), not(d))))"));
        ATermUtils.assertTrue(a.equals((Object)factory.parse("all(p,and(c,d))")));
        a = ATermUtils.nnf(factory.parse("not(min(p,2))"));
        ATermUtils.assertTrue(a.equals((Object)factory.parse("max(p,1))")));
    }

    public void testNormalize() {
        ATerm a = Test.term("some(r,and([c,and([e,not(d)])]))");
        ATerm b = Test.term("all(r,or([d,or([not(c),not(e)])]))");
        ATerm t = ATermUtils.makeAnd(a, b);
        t = Test.term("and([or([a,b,c]),or([a,b,d])])");
        long time = System.currentTimeMillis();
        t = ATermUtils.normalize(t);
        System.out.println(System.currentTimeMillis() - time);
        System.out.println(t);
    }

    void testBackjumping() throws Exception {
        ABox.DEBUG = true;
        ABox.USE_BACKJUMPING = true;
        ATerm c = ATermUtils.makeAnd(ATermUtils.makeList(new ATerm[]{ATermUtils.makeOr(Test.term("C1"), Test.term("D1")), ATermUtils.makeOr(Test.term("C2"), Test.term("D2")), ATermUtils.makeOr(Test.term("C3"), Test.term("D3")), ATermUtils.makeOr(Test.term("C4"), Test.term("D4")), ATermUtils.makeOr(Test.term("C5"), Test.term("D5")), ATermUtils.makeSomeValues(Test.term("R"), (ATerm)ATermUtils.makeAllValues(Test.term("invR"), (ATerm)ATermUtils.makeNot(Test.term("C3"))))}));
        ABox abox = new ABox();
        abox.tbox = TBox.createSplitTBox(ATermUtils.makeList());
        abox.rbox.addObjectRole(Test.term("R"));
        abox.rbox.addObjectRole(Test.term("invR"));
        abox.rbox.addInverseRole(Test.term("invR"), Test.term("R"));
        System.out.println("isSatisfiable " + abox.isSatisfiable(c));
    }

    public void test() {
        ATermList l1 = (ATermList)factory.parse("[a,b,c,d]");
        ATermList l2 = (ATermList)factory.parse("[e,a,f,b]");
        System.out.println(ATermUtils.union(l1, l2));
        System.out.println(ATermUtils.nnf(factory.parse("not(and(p,c))")));
        ATerm t = factory.parse("[same(x,a),sub(a,b),sub(a,d)]");
        TBox tbox = TBox.createSplitTBox((ATermList)t);
        System.out.println(tbox.Tu.toList().toString());
        System.out.println("TBox: \n" + tbox.Tu);
        try {
            tbox = new TuBox(tbox.Tu.unfold());
            System.out.println("\nUnfolded TBox:\n" + tbox.Tu);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testSubmitRDF() throws Exception {
        String base = "http://swint.mindswap.org/2003/submit-rdf/";
        int i = 10;
        while (i < 22) {
            String uri = String.valueOf(base) + i + ".rdf";
            try {
                System.out.println("Reading " + uri);
                Model model = ModelFactory.createDefaultModel();
                model.read(uri);
                Test.remapNSPrefix(model);
                System.out.println("Writing " + i + ".rdf");
                model.write((OutputStream)new FileOutputStream(String.valueOf(i) + ".rdf"));
            }
            catch (Exception e) {
                System.out.println("Error: " + e);
            }
            ++i;
        }
    }

    public static void remapNSPrefix(Model m) {
        Map map = m.getNsPrefixMap();
        int j = 0;
        Iterator i = map.values().iterator();
        while (i.hasNext()) {
            m.setNsPrefix("ns" + j++, (String)i.next());
        }
    }

    public void testNCI() throws Exception {
        String base = "http://www.example.org/test#";
        Model model = ModelFactory.createDefaultModel();
        long time = System.currentTimeMillis();
        model.read((InputStream)new FileInputStream("C:\\mindswap\\tools\\ncibrowser\\nciOncology.owl"), "http://nci/");
        time = System.currentTimeMillis() - time;
        System.out.println("Parsed " + time + " ms");
        time = System.currentTimeMillis();
        StmtIterator i = model.listStatements(null, RDF.type, null);
        time = System.currentTimeMillis() - time;
        System.out.println("Query " + time + " ms");
        System.out.println(i.next());
    }

    public void testQuery() throws Exception {
        ABox.DEBUG = false;
        OWLReasoner.DEBUG = false;
        String onto = "t";
        String input = Pellet.toURI(String.valueOf(onto) + "Premises.owl");
        String query = Pellet.toURI(String.valueOf(onto) + "Query.owl");
        input = Pellet.toURI("../jshop-ws/travel_p1.rdf");
        query = "../jshop-ws/travel.query";
        OWLReasoner reasoner = new OWLReasoner();
        reasoner.loadOntology(input);
        Query q = new Query(Util.getFileAsString("../jshop-ws/travel.query"));
        q.setData(reasoner.getABox());
        Vector results = q.exec();
        if (results != null) {
            System.out.println("Query is consistent!");
            System.out.println("Results: " + results.size());
            int i = 0;
            while (i < results.size()) {
                System.out.println(String.valueOf(i) + ") " + results.get(i));
                ++i;
            }
        } else {
            System.out.println("Query is inconsistent!");
        }
    }

    static ATerm term(String s) {
        return factory.parse(s);
    }
}

