/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.Pellet;

public class EdgeList {
    List list = new ArrayList();

    public void addEdgeList(EdgeList edges) {
        Pellet.timers.startTimer("addEdgeList");
        if (edges == null) {
            return;
        }
        this.list.addAll(edges.list);
        Pellet.timers.stopTimer("addEdgeList");
    }

    public void addEdge(Edge e) {
        this.list.add(e);
    }

    public void removeEdge(Edge edge) {
        EdgeSelector es = new EdgeSelector(edge);
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Edge e = (Edge)i.next();
            if (!es.acceptEdge(e)) continue;
            i.remove();
            break;
        }
    }

    public Edge edgeAt(int i) {
        return (Edge)this.list.get(i);
    }

    public int size() {
        return this.list.size();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public Iterator iterator() {
        return this.list.iterator();
    }

    private EdgeList getEdges(EdgeSelector es) {
        EdgeList result = new EdgeList();
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Edge e = (Edge)i.next();
            if (!es.acceptEdge(e)) continue;
            result.addEdge(e);
        }
        return result;
    }

    public EdgeList getEdgesFrom(ATerm from) {
        return this.getEdges(new EdgeSelector(new Edge(null, from, null, null)));
    }

    public EdgeList getEdgesTo(ATerm to) {
        return this.getEdges(new EdgeSelector(new Edge(null, null, to, null)));
    }

    public EdgeList getEdgesNamed(ATerm name) {
        return this.getEdges(new EdgeSelector(new Edge(name, null, null, null)));
    }

    public ATerm[] getNeighbors(ATerm node) {
        ATerm[] result = new ATerm[this.size()];
        int i = 0;
        while (i < this.size()) {
            Edge edge = this.edgeAt(i);
            result[i] = edge.from.equals((Object)node) ? edge.to : edge.from;
            ++i;
        }
        return result;
    }

    public boolean hasEdgeFrom(ATerm from) {
        return this.getEdgesFrom(from).size() > 0;
    }

    public boolean hasEdgeTo(ATerm to) {
        return this.getEdgesTo(to).size() > 0;
    }

    public boolean hasEdge(ATerm name) {
        return this.getEdgesNamed(name).size() > 0;
    }

    public boolean hasEdge(Edge e) {
        return this.getEdges(new EdgeSelector(e)).size() > 0;
    }

    public String toString() {
        return this.list.toString();
    }

    class EdgeSelector {
        Edge template;

        EdgeSelector(Edge template) {
            this.template = template;
        }

        public boolean acceptEdge(Edge e) {
            if (this.template.from != null && !this.template.from.equals((Object)e.from)) {
                return false;
            }
            if (this.template.to != null && !this.template.to.equals((Object)e.to)) {
                return false;
            }
            return this.template.name == null || this.template.name.equals((Object)e.name);
        }
    }
}

