/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import com.hp.hpl.jena.vocabulary.RDF;
import java.util.Hashtable;
import org.mindswap.pellet.IntervalList;

public class Datatype {
    public static final String XSD_URI = "http://www.w3.org/2001/XMLSchema#";
    public static final String RDF_URI = RDF.getURI();
    public static final long NegInf = Long.MIN_VALUE;
    public static final long PosInf = Long.MAX_VALUE;
    private static Hashtable typeMapping = new Hashtable();
    protected boolean negated;

    void negate() {
        this.negated = !this.negated;
    }

    void setValue(Object value) {
    }

    public static class DTInteger
    extends Datatype {
        IntervalList values = new IntervalList();

        DTInteger(boolean negated) {
            this.negated = negated;
        }

        DTInteger(long min, long max, boolean negated) {
            this(negated);
            this.values.addInterval(min, max);
            this.negated = negated;
        }

        DTInteger(long min, long max) {
            this(min, max, false);
        }

        DTInteger(long exactValue, boolean negated) {
            this(exactValue, exactValue, negated);
        }

        DTInteger(long exactValue) {
            this(exactValue, false);
        }

        DTInteger(long[] exactValues) {
            this(false);
            int i = 0;
            while (i < exactValues.length) {
                this.values.addInterval(exactValues[i], exactValues[i]);
                ++i;
            }
        }

        public String toString() {
            return this.values.toString();
        }
    }

    public static class DTString
    extends Datatype {
        String pattern;

        DTString(String pattern, boolean negated) {
            this.pattern = pattern;
            this.negated = negated;
        }

        DTString(String pattern) {
            this(pattern, false);
        }

        DTString() {
            this(null, false);
        }
    }

    public static class DTBoolean
    extends Datatype {
        Boolean value = null;

        void setValue(Object value) {
            if (value instanceof Boolean) {
                this.value = (Boolean)value;
            } else if (value instanceof String) {
                String str = value.toString().toLowerCase();
                if (str.equals("true")) {
                    value = Boolean.TRUE;
                } else if (str.equals("false")) {
                    value = Boolean.FALSE;
                }
            }
        }
    }

    public static class DTFloat
    extends Datatype {
    }

    public static class DTDateTime
    extends Datatype {
    }

    public static class DTAnyURI
    extends Datatype {
    }

    public static class DTDuration
    extends Datatype {
    }

    public static class DTBinary
    extends Datatype {
    }

    public static class DTToken
    extends Datatype {
    }

    public static class DTLiteral
    extends DTString {
        DTLiteral(String pattern) {
            super(pattern, false);
        }

        DTLiteral() {
            super(null, false);
        }
    }

    public static class DTXMLLiteral
    extends Datatype {
    }
}

