/*
 * Decompiled with CFR 0.152.
 */
package ix.util.owls;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDFSyntax;
import java.io.Writer;
import java.net.URI;
import org.mindswap.owl.OWLResource;
import org.mindswap.owl.Util;
import org.mindswap.owl.vocabulary.RDF;
import org.mindswap.owl.vocabulary.RDFS;
import org.mindswap.owls.OWLSFactory;
import org.mindswap.owls.grounding.AtomicGrounding;
import org.mindswap.owls.grounding.Grounding;
import org.mindswap.owls.grounding.MessageMap;
import org.mindswap.owls.grounding.MessageMapList;
import org.mindswap.owls.grounding.UPnPAtomicGrounding;
import org.mindswap.owls.grounding.WSDLAtomicGrounding;
import org.mindswap.owls.io.impl.OWLSWriterImpl;
import org.mindswap.owls.process.AtomicProcess;
import org.mindswap.owls.process.CompositeProcess;
import org.mindswap.owls.process.ControlConstruct;
import org.mindswap.owls.process.DataFlow;
import org.mindswap.owls.process.DataFlowElement;
import org.mindswap.owls.process.Input;
import org.mindswap.owls.process.Parameter;
import org.mindswap.owls.process.ParameterList;
import org.mindswap.owls.process.Process;
import org.mindswap.owls.process.ProcessComponent;
import org.mindswap.owls.process.ProcessComponentList;
import org.mindswap.owls.process.ProcessModel;
import org.mindswap.owls.process.Sequence;
import org.mindswap.owls.profile.Profile;
import org.mindswap.owls.service.Service;
import org.mindswap.owls.vocabulary.FLAServiceOnt;
import org.mindswap.owls.vocabulary.OWLS;
import org.mindswap.owls.vocabulary.OWLS_1_0;

public class ProcessWriter
extends OWLSWriterImpl {
    public static boolean DEBUG = false;
    private Model model = null;
    private URI base = null;
    private OWLS_1_0 OWLS = OWLS_1_0.instance;
    private Property OWLS_Process_theParameter = ResourceFactory.createProperty((String)"http://www.daml.org/services/owl-s/1.0/Process.owl#theParameter");
    private Property OWLS_Process_atProcess = ResourceFactory.createProperty((String)"http://www.daml.org/services/owl-s/1.0/Process.owl#atProcess");

    public ProcessWriter() {
        this.version = "1.0";
    }

    public void write(Service service, Writer writer) {
        this.model = ModelFactory.createDefaultModel();
        this.model.setNsPrefix("service", this.OWLS.Service.URI);
        this.model.setNsPrefix("profile", this.OWLS.Profile.URI);
        this.model.setNsPrefix("process", this.OWLS.Process.URI);
        this.model.setNsPrefix("grounding", this.OWLS.Grounding.URI);
        this.base = service.getFileURI();
        RDFWriter rDFWriter = this.model.getWriter("RDF/XML-ABBREV");
        rDFWriter.setProperty("allowBadURIs", (Object)"true");
        rDFWriter.setProperty("blockRules", (Object)new Resource[]{RDFSyntax.propertyAttr});
        rDFWriter.setProperty("showXmlDeclaration", (Object)"true");
        rDFWriter.setProperty("prettyTypes", (Object)new Resource[]{OWL.Ontology, this.makeResource(this.OWLS.Service.Service)});
        this.writeService(service);
        rDFWriter.write(this.model, writer, "");
    }

    private Resource makeResource(URI uRI) {
        return ResourceFactory.createResource((String)uRI.toString());
    }

    private Resource toRDF(URI uRI) {
        if (this.base != null) {
            uRI = this.base.relativize(uRI);
        }
        return Util.toResource((URI)uRI);
    }

    private Resource toRDF(OWLResource oWLResource) {
        return oWLResource.getJenaResource();
    }

    private RDFNode toRDF(String string) {
        return this.toRDF(string, false);
    }

    private RDFNode toRDF(String string, boolean bl) {
        return this.model.createLiteral(string, bl);
    }

    private void addStatement(Object object, Object object2, Object object3) {
        Resource resource = null;
        Property property = null;
        RDFNode rDFNode = null;
        if (object instanceof Resource) {
            resource = (Resource)object;
        } else if (object instanceof OWLResource) {
            resource = this.toRDF((OWLResource)object);
        } else if (object instanceof URI) {
            resource = this.toRDF((URI)object);
        } else {
            throw new RuntimeException("Invalid subject " + object + " " + object.getClass());
        }
        if (object2 instanceof Property) {
            property = (Property)object2;
        } else if (object2 instanceof URI) {
            property = Util.toProperty((URI)((URI)object2));
        } else {
            throw new RuntimeException("Invalid property " + object2 + " " + object2.getClass());
        }
        if (object3 instanceof RDFNode) {
            rDFNode = (RDFNode)object3;
        } else if (object3 instanceof OWLResource) {
            rDFNode = this.toRDF((OWLResource)object3);
        } else if (object3 instanceof URI) {
            rDFNode = this.toRDF((URI)object3);
        } else if (object3 instanceof String) {
            rDFNode = this.toRDF((String)object3);
        } else {
            throw new RuntimeException("Invalid object " + object3 + " " + object3.getClass());
        }
        this.model.add(resource, property, rDFNode);
    }

    private void writeService(Service service) {
        this.addStatement(service, RDF.type, this.OWLS.Service.Service);
        if (service.getProfile() != null) {
            this.addStatement(service, this.OWLS.Service.presents, service.getProfile());
        }
        if (service.getProcessModel() != null) {
            this.addStatement(service, this.OWLS.Service.describedBy, service.getProcessModel());
        }
        if (service.getGrounding() != null) {
            this.addStatement(service, this.OWLS.Service.supports, service.getGrounding());
        }
        if (service.getProfile() != null) {
            this.writeProfile(service.getProfile());
        }
        if (service.getProcessModel() != null) {
            this.writeProcessModel(service.getProcessModel());
        }
        if (service.getGrounding() != null) {
            this.writeGrounding(service.getGrounding());
        }
    }

    private void writeProfile(Profile profile) {
        URI uRI = profile.getType();
        for (int i = 0; i < OWLSFactory.supportedVersions.length; ++i) {
            String string = OWLSFactory.supportedVersions[i];
            OWLS oWLS = OWLSFactory.getVocabulary((String)string);
            if (!uRI.equals(oWLS.getProfile().Profile)) continue;
            uRI = this.OWLS.Profile.Profile;
            break;
        }
        this.addStatement(profile, RDF.type, uRI);
        this.addStatement(profile, this.OWLS.Service.presentedBy, profile.getService());
        if (profile.getLabel() != null) {
            this.addStatement(profile, this.OWLS.Profile.serviceName, profile.getLabel());
            this.addStatement(profile, RDFS.label, profile.getLabel());
        }
        if (profile.getTextDescription() != null) {
            this.addStatement(profile, this.OWLS.Profile.textDescription, profile.getTextDescription());
        }
        this.writeProfileParams(profile, (ParameterList)profile.getInputs());
        this.writeProfileParams(profile, (ParameterList)profile.getOutputs());
    }

    private void writeProfileParams(Profile profile, ParameterList parameterList) {
        for (int i = 0; i < parameterList.size(); ++i) {
            Parameter parameter = parameterList.parameterAt(i);
            if (parameter instanceof Input) {
                this.addStatement(profile, this.OWLS.Profile.hasInput, parameter);
                continue;
            }
            this.addStatement(profile, this.OWLS.Profile.hasOutput, parameter);
        }
    }

    private void writeProcessModel(ProcessModel processModel) {
        this.addStatement(processModel, RDF.type, this.OWLS.Process.ProcessModel);
        this.addStatement(processModel, this.OWLS.Service.describes, processModel.getService());
        this.addStatement(processModel, this.OWLS.Process.hasProcess, processModel.getProcess());
        this.writeProcess(processModel.getProcess());
    }

    private void writeProcess(Process process) {
        if (process instanceof AtomicProcess) {
            this.writeAtomicProcess((AtomicProcess)process);
        } else if (process instanceof CompositeProcess) {
            this.writeCompositeProcess((CompositeProcess)process);
        }
        this.writeProcessParams(process, (ParameterList)process.getInputs());
        this.writeProcessParams(process, (ParameterList)process.getOutputs());
        this.writeDefaultValues(process);
        this.writeDataFlow(process);
    }

    private void writeAtomicProcess(AtomicProcess atomicProcess) {
        this.addStatement(atomicProcess, RDF.type, this.OWLS.Process.AtomicProcess);
        this.writeProcessParams((Process)atomicProcess, (ParameterList)atomicProcess.getInputs());
        this.writeProcessParams((Process)atomicProcess, (ParameterList)atomicProcess.getOutputs());
    }

    private void writeProcessParams(Process process, ParameterList parameterList) {
        for (int i = 0; i < parameterList.size(); ++i) {
            Parameter parameter = parameterList.parameterAt(i);
            if (parameter instanceof Input) {
                this.addStatement(process, this.OWLS.Process.hasInput, parameter);
                this.addStatement(parameter, RDF.type, this.OWLS.Process.Input);
            } else {
                this.addStatement(process, this.OWLS.Process.hasOutput, parameter);
                this.addStatement(parameter, RDF.type, this.OWLS.Process.Output);
            }
            this.addStatement(parameter, this.OWLS.Process.parameterType, parameter.getType());
            if (parameter.getLabel() == null) continue;
            this.addStatement(parameter, RDFS.label, parameter.getLabel());
        }
    }

    private void writeCompositeProcess(CompositeProcess compositeProcess) {
        this.addStatement(compositeProcess, RDF.type, this.OWLS.Process.CompositeProcess);
        RDFNode rDFNode = this.writeControlConstruct(compositeProcess.getComposedOf());
        this.addStatement(compositeProcess, this.OWLS.Process.composedOf, rDFNode);
    }

    private RDFNode writeProcessComponent(ProcessComponent processComponent) {
        if (processComponent instanceof Process) {
            this.writeProcess((Process)processComponent);
            return processComponent.getJenaResource();
        }
        return this.writeControlConstruct((ControlConstruct)processComponent);
    }

    private RDFNode writeControlConstruct(ControlConstruct controlConstruct) {
        RDFNode rDFNode = null;
        if (controlConstruct instanceof Sequence) {
            rDFNode = this.writeSequence((Sequence)controlConstruct);
        }
        return rDFNode;
    }

    private RDFNode writeSequence(Sequence sequence) {
        RDFNode rDFNode = this.writeComponents(sequence.getComponents());
        this.addStatement(sequence, RDF.type, this.OWLS.Process.Sequence);
        this.addStatement(sequence, this.OWLS.Process.components, rDFNode);
        return sequence.getJenaResource();
    }

    private RDFNode writeComponents(ProcessComponentList processComponentList) {
        RDFNode[] rDFNodeArray = new RDFNode[processComponentList.size()];
        for (int i = 0; i < processComponentList.size(); ++i) {
            ProcessComponent processComponent = processComponentList.processComponentAt(i);
            rDFNodeArray[i] = this.writeProcessComponent(processComponent);
        }
        return this.model.createList(rDFNodeArray);
    }

    private void writeDataFlow(Process process) {
        DataFlow dataFlow = process.getDataFlow();
        for (int i = 0; i < dataFlow.size(); ++i) {
            DataFlowElement dataFlowElement = dataFlow.dfeAt(i);
            RDFNode[] rDFNodeArray = new RDFNode[dataFlowElement.size()];
            for (int j = 0; j < dataFlowElement.size(); ++j) {
                Parameter parameter = dataFlowElement.parameterAt(j);
                rDFNodeArray[j] = ResourceFactory.createResource();
                this.addStatement(rDFNodeArray[j], RDF.type, this.OWLS.Process.ValueOf);
                this.addStatement(rDFNodeArray[j], this.OWLS_Process_theParameter, parameter);
                if (parameter.getProcess() == null) continue;
                this.addStatement(rDFNodeArray[j], this.OWLS_Process_atProcess, parameter.getProcess());
            }
            this.addStatement(process, this.OWLS.Process.sameValues, this.model.createList(rDFNodeArray));
        }
    }

    private void writeDefaultValues(Process process) {
    }

    private void writeGrounding(Grounding grounding) {
        boolean bl = false;
        boolean bl2 = false;
        this.addStatement(grounding, this.OWLS.Service.supportedBy, grounding.getService());
        for (Object e : grounding.getAtomicGroundings()) {
            AtomicGrounding atomicGrounding = (AtomicGrounding)e;
            bl = bl || atomicGrounding instanceof WSDLAtomicGrounding;
            boolean bl3 = bl2 = bl2 && atomicGrounding instanceof UPnPAtomicGrounding;
            if (atomicGrounding instanceof WSDLAtomicGrounding) {
                this.addStatement(grounding, this.OWLS.Grounding.hasAtomicProcessGrounding, atomicGrounding);
                this.writeWSDLGrounding((WSDLAtomicGrounding)atomicGrounding);
                continue;
            }
            if (!(atomicGrounding instanceof UPnPAtomicGrounding)) continue;
            this.addStatement(grounding, this.OWLS.Grounding.hasAtomicProcessGrounding, atomicGrounding);
            this.writeUPnPGrounding((UPnPAtomicGrounding)atomicGrounding);
        }
        this.addStatement(grounding, this.OWLS.Service.supportedBy, grounding.getService());
        if (bl) {
            this.addStatement(grounding, RDF.type, this.OWLS.Grounding.WsdlGrounding);
        } else if (bl2) {
            this.addStatement(grounding, RDF.type, FLAServiceOnt.UPnPGrounding);
        }
    }

    private void writeWSDLGrounding(WSDLAtomicGrounding wSDLAtomicGrounding) {
        this.addStatement(wSDLAtomicGrounding, RDF.type, this.OWLS.Grounding.WsdlAtomicProcessGrounding);
        this.addStatement(wSDLAtomicGrounding, this.OWLS.Grounding.wsdlDocument, wSDLAtomicGrounding.getWSDL());
        this.addStatement(wSDLAtomicGrounding, this.OWLS.Grounding.owlsProcess, wSDLAtomicGrounding.getProcess());
        try {
            this.addStatement(wSDLAtomicGrounding, this.OWLS.Grounding.wsdlInputMessage, wSDLAtomicGrounding.getInputMessage());
            this.addStatement(wSDLAtomicGrounding, this.OWLS.Grounding.wsdlOutputMessage, wSDLAtomicGrounding.getOutputMessage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Resource resource = ResourceFactory.createResource();
        this.addStatement(wSDLAtomicGrounding, this.OWLS.Grounding.wsdlOperation, resource);
        this.addStatement(resource, RDF.type, this.OWLS.Grounding.WsdlOperationRef);
        if (wSDLAtomicGrounding.getPortType() != null) {
            this.addStatement(resource, this.OWLS.Grounding.portType, wSDLAtomicGrounding.getPortType());
        }
        this.addStatement(resource, this.OWLS.Grounding.operation, wSDLAtomicGrounding.getOperation());
        this.writeWSDLGroundingParams(wSDLAtomicGrounding, true);
        this.writeWSDLGroundingParams(wSDLAtomicGrounding, false);
    }

    private void writeWSDLGroundingParams(WSDLAtomicGrounding wSDLAtomicGrounding, boolean bl) {
        MessageMapList messageMapList = bl ? wSDLAtomicGrounding.getInputMap() : wSDLAtomicGrounding.getOutputMap();
        if (messageMapList.size() == 0) {
            return;
        }
        RDFNode[] rDFNodeArray = new RDFNode[messageMapList.size()];
        for (int i = 0; i < messageMapList.size(); ++i) {
            MessageMap messageMap = messageMapList.messageMapAt(i);
            Resource resource = ResourceFactory.createResource();
            this.addStatement(resource, RDF.type, this.OWLS.Grounding.wsdlMessageMap);
            this.addStatement(resource, this.OWLS.Grounding.owlsParameter, messageMap.getOWLSParameter());
            this.addStatement(resource, this.OWLS.Grounding.wsdlMessagePart, messageMap.getGroundingParameter());
            if (messageMap.getTransformation() != null) {
                this.addStatement(resource, this.OWLS.Grounding.xsltTransformation, this.toRDF(messageMap.getTransformation(), true));
            }
            rDFNodeArray[i] = resource;
        }
        RDFList rDFList = this.model.createList(rDFNodeArray);
        if (bl) {
            this.addStatement(wSDLAtomicGrounding, this.OWLS.Grounding.wsdlInputMessageParts, rDFList);
        } else {
            this.addStatement(wSDLAtomicGrounding, this.OWLS.Grounding.wsdlOutputMessageParts, rDFList);
        }
    }

    private void writeUPnPGrounding(UPnPAtomicGrounding uPnPAtomicGrounding) {
        this.addStatement(uPnPAtomicGrounding, RDF.type, FLAServiceOnt.UPnPAtomicProcessGrounding);
        this.addStatement(uPnPAtomicGrounding, this.OWLS.Grounding.owlsProcess, uPnPAtomicGrounding.getProcess());
        this.addStatement(uPnPAtomicGrounding, FLAServiceOnt.upnpCommand, uPnPAtomicGrounding.getUPnPAction());
        this.addStatement(uPnPAtomicGrounding, FLAServiceOnt.upnpDeviceURL, uPnPAtomicGrounding.getUPnPDescription());
        this.addStatement(uPnPAtomicGrounding, FLAServiceOnt.upnpServiceID, uPnPAtomicGrounding.getUPnPService());
        this.writeUPnPGroundingParams(uPnPAtomicGrounding, true);
        this.writeUPnPGroundingParams(uPnPAtomicGrounding, false);
    }

    private void writeUPnPGroundingParams(UPnPAtomicGrounding uPnPAtomicGrounding, boolean bl) {
        MessageMapList messageMapList = bl ? uPnPAtomicGrounding.getInputMap() : uPnPAtomicGrounding.getOutputMap();
        if (messageMapList.size() == 0) {
            return;
        }
        RDFNode[] rDFNodeArray = new RDFNode[messageMapList.size()];
        for (int i = 0; i < messageMapList.size(); ++i) {
            MessageMap messageMap = messageMapList.messageMapAt(i);
            Resource resource = ResourceFactory.createResource();
            this.addStatement(resource, RDF.type, FLAServiceOnt.UPnPMap);
            this.addStatement(resource, this.OWLS.Grounding.owlsParameter, messageMap.getOWLSParameter());
            this.addStatement(resource, FLAServiceOnt.upnpParameter, messageMap.getGroundingParameter());
            if (messageMap.getTransformation() != null) {
                this.addStatement(resource, this.OWLS.Grounding.xsltTransformation, this.toRDF(messageMap.getTransformation(), true));
            }
            rDFNodeArray[i] = resource;
        }
        RDFList rDFList = this.model.createList(rDFNodeArray);
        if (bl) {
            this.addStatement(uPnPAtomicGrounding, FLAServiceOnt.UPnPInputMapping, rDFList);
        } else {
            this.addStatement(uPnPAtomicGrounding, FLAServiceOnt.UPnPOutputMapping, rDFList);
        }
    }
}

