/*
 * Decompiled with CFR 0.152.
 */
package ix.util.http;

import ix.util.Debug;
import ix.util.RethrownException;
import ix.util.Strings;
import ix.util.Util;
import ix.util.ipc.ServiceAddress;
import ix.util.xml.XML;
import ix.util.xml.XMLTranslator;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.LinkedList;
import org.jdom.Document;
import org.jdom.output.XMLOutputter;

public class HttpUtilities {
    private XMLTranslator xmlt = XML.config().makeXMLTranslator();

    public HttpUtilities() {
        this.xmlt.setOmitImplAttributes(false);
    }

    public String getHostName() {
        try {
            return Util.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            throw new RethrownException(unknownHostException);
        }
    }

    public URL makeMessageURL(ServiceAddress serviceAddress, String string) {
        try {
            return new URL("http", serviceAddress.getHost(), serviceAddress.getPort(), string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RethrownException("Can't make a URL from " + serviceAddress + ". ", malformedURLException);
        }
    }

    public byte[] encodeForSend(Object object) {
        return this.encodeForSend(object, "UTF-8");
    }

    public byte[] encodeForSend(Object object, String string) {
        Document document = this.xmlt.objectToDocument(object);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, string);
            XMLOutputter xMLOutputter = XML.makePrettyXMLOutputter();
            xMLOutputter.output(document, (Writer)outputStreamWriter);
            outputStreamWriter.close();
        }
        catch (IOException iOException) {
            throw new RethrownException(iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public Object decodeReceived(String string) {
        if (string == null) {
            return null;
        }
        return this.xmlt.objectFromXML(string);
    }

    public String getContentCharset(String string) {
        String string2 = "charset=";
        int n = string.indexOf(string2);
        if (n > 0) {
            return string.substring(n + string2.length());
        }
        return null;
    }

    public String readContent(InputStream inputStream, int n, String string) throws IOException {
        if (n < 0) {
            Debug.noteln("No contet length; will read everything.");
            InputStreamReader inputStreamReader = string == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string);
            return this.readAllLines(inputStreamReader);
        }
        return this.readText(inputStream, n, string);
    }

    public String readText(InputStream inputStream, int n, String string) throws IOException {
        byte[] byArray = new byte[n];
        int n2 = n;
        int n3 = 0;
        while (n2 > 0) {
            int n4 = inputStream.read(byArray, n3, n2);
            if (n4 == -1) {
                throw new EOFException();
            }
            n2 -= n4;
            n3 += n4;
        }
        return new String(byArray, string);
    }

    public String readAllLines(Reader reader) throws IOException {
        String string;
        BufferedReader bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        LinkedList<String> linkedList = new LinkedList<String>();
        while ((string = bufferedReader.readLine()) != null) {
            linkedList.add(string);
        }
        return Strings.joinLines(linkedList);
    }
}

