/*
 * Decompiled with CFR 0.152.
 */
package ix.util;

import ix.icore.IXAgent;
import ix.test.LongToBytes;
import ix.test.SecureRandomTest;
import ix.util.Debug;
import ix.util.FutureValue;
import ix.util.Name;
import ix.util.Parameters;
import ix.util.RethrownException;
import ix.util.Util;
import ix.util.lisp.Symbol;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Gensym {
    private static Generator defaultGenerator = new Generator();
    private static FutureValue futureRandom = null;

    private Gensym() {
    }

    public static Generator getDefaultGenerator() {
        return defaultGenerator;
    }

    public static void setDefaultGenerator(Generator generator) {
        defaultGenerator = generator;
    }

    public static void useUniquePrefix() {
        defaultGenerator.useUniquePrefix();
    }

    public static boolean usingUniquePrefix() {
        return defaultGenerator.usingUniquePrefix();
    }

    public static String nextString(String string) {
        return defaultGenerator.nextString(string);
    }

    public static Name nextName(String string) {
        return defaultGenerator.nextName(string);
    }

    public static Symbol nextSymbol(String string) {
        return defaultGenerator.nextSymbol(string);
    }

    public static Symbol nextNewSymbol(String string) {
        return defaultGenerator.nextNewSymbol(string);
    }

    private static String getHostName() {
        try {
            return Util.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            throw new RethrownException(unknownHostException);
        }
    }

    private static String getSymbolName() {
        IXAgent iXAgent = IXAgent.getAgent();
        if (iXAgent != null) {
            return iXAgent.getAgentSymbolName();
        }
        return null;
    }

    private static boolean haveRandomSourceDevice() {
        if (!Parameters.getBoolean("allow-random-device", false)) {
            return false;
        }
        try {
            return new File("/dev/random").canRead();
        }
        catch (SecurityException securityException) {
            Debug.noteException(securityException);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Long getLongFromRandomSourceDevice() {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream("/dev/random");
            long l = new DataInputStream(fileInputStream).readLong();
            Debug.noteln("Random long from /dev/random " + l);
            Long l2 = new Long(l);
            return l2;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            Debug.noteException(iOException, false);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {
                    Debug.noteException(exception);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getRandomLong() {
        Object object;
        if (Gensym.haveRandomSourceDevice() && (object = Gensym.getLongFromRandomSourceDevice()) != null) {
            return (Long)object;
        }
        object = Gensym.class;
        synchronized (Gensym.class) {
            if (futureRandom == null) {
                Debug.noteln("Unexpected null futureRandom");
                futureRandom = new SecureRandomTest.FutureRandom();
                futureRandom.start();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            object = (Long)futureRandom.getValue();
            Debug.noteln("Random long from secure random", object);
            return (Long)object;
        }
    }

    private static MessageDigest makeMessageDigest() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RethrownException(noSuchAlgorithmException);
        }
    }

    public static void main(String[] stringArray) {
        Parameters.processCommandLineArguments(stringArray);
        defaultGenerator = new Generator();
        Debug.noteln("An id", (Object)Gensym.nextString("issue"));
        Gensym.useUniquePrefix();
        IXAgent iXAgent = new IXAgent(){};
        iXAgent.mainStartup(stringArray);
        Debug.noteln("Unique id", (Object)Gensym.nextString("issue"));
    }

    public static class Generator {
        protected boolean useUnique = false;
        protected boolean useHash = Parameters.getBoolean("use-hash-ids", false);
        protected Map counters = new HashMap();
        protected long initialNumber = 0L;
        protected String separator = "-";
        protected String prefix = null;

        public void setInitialNumber(long l) {
            this.initialNumber = l;
        }

        public void setSeparator(String string) {
            this.separator = string;
        }

        public void setPrefix(String string) {
            this.prefix = string;
        }

        public boolean usingUniquePrefix() {
            return this.useUnique;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void useUniquePrefix() {
            Class<Gensym> clazz = Gensym.class;
            synchronized (Gensym.class) {
                if (futureRandom == null && !Gensym.haveRandomSourceDevice()) {
                    futureRandom = new SecureRandomTest.FutureRandom();
                    futureRandom.start();
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                this.useUnique = true;
                this.prefix = null;
                return;
            }
        }

        private String ensurePrefix() {
            if (this.prefix == null) {
                if (this.useUnique) {
                    this.prefix = this.makeUniquePrefix();
                    return this.prefix;
                }
                return "";
            }
            return this.prefix;
        }

        protected String makeUniquePrefix() {
            return this.useHash ? this.makeHashPrefix() : this.makeLongPrefix();
        }

        protected String makeLongPrefix() {
            String string = Gensym.getSymbolName();
            return "http://" + Gensym.getHostName() + (string == null ? "" : "/" + string) + "/" + LongToBytes.encode(System.currentTimeMillis()) + "/" + LongToBytes.encode(Gensym.getRandomLong()) + "/";
        }

        protected String makeHashPrefix() {
            IXAgent iXAgent = IXAgent.getAgent();
            Date date = iXAgent.getAgentStartupDate();
            MessageDigest messageDigest = Gensym.makeMessageDigest();
            messageDigest.update(Gensym.getHostName().getBytes());
            messageDigest.update(iXAgent.getAgentSymbolName().getBytes());
            messageDigest.update(LongToBytes.longToBytes(date.getTime()));
            messageDigest.update(LongToBytes.longToBytes(System.currentTimeMillis()));
            messageDigest.update(LongToBytes.longToBytes(Gensym.getRandomLong()));
            byte[] byArray = messageDigest.digest();
            return "http://www.aiai.ed.ac.uk/project/ix/id/" + LongToBytes.bytesToLongStrings(byArray) + "/";
        }

        public String nextString(String string) {
            Long l = (Long)this.counters.get(string);
            if (l == null) {
                l = new Long(this.initialNumber);
                this.counters.put(string, l);
            }
            long l2 = l;
            this.counters.put(string, new Long(l2 + 1L));
            return (this.prefix == null ? this.ensurePrefix() : this.prefix) + string + this.separator + l2;
        }

        public Name nextName(String string) {
            return Name.valueOf(this.nextString(string));
        }

        public Symbol nextSymbol(String string) {
            return Symbol.intern(this.nextString(string));
        }

        public Symbol nextNewSymbol(String string) {
            String string2 = string;
            while (Symbol.exists(string2)) {
                string2 = this.nextString(string2);
            }
            return Symbol.intern(string2);
        }
    }
}

