/*
 * Decompiled with CFR 0.152.
 */
package ix.util;

import ix.util.ConsistencyException;
import ix.util.Debug;
import ix.util.Function1;
import ix.util.Predicate1;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;

public final class Fn {
    public static final Predicate1 alwaysTrue = new Predicate1(){

        public boolean trueOf(Object object) {
            return true;
        }
    };
    public static final Predicate1 alwaysFalse = new Predicate1(){

        public boolean trueOf(Object object) {
            return false;
        }
    };
    public static final Function1 identity = new Function1(){

        public Object funcall(Object object) {
            return object;
        }
    };

    private Fn() {
    }

    public static Object apply(Object object, String string, List list) {
        return Fn.apply(object, string, list.toArray());
    }

    public static Object apply(Object object, String string, Object[] objectArray) {
        Method method = Fn.getMethod(object, string, objectArray);
        if (method != null) {
            return Fn.apply(object, method, objectArray);
        }
        throw new IllegalArgumentException("Could not find a " + string + " method " + "for " + object + " and arguments " + Arrays.asList(objectArray));
    }

    public static Object apply(Object object, Method method, Object[] objectArray) {
        try {
            return method.invoke(object, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Error("Cannot access method " + method, illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException("Exception from method " + method + ": " + Debug.describeException(invocationTargetException.getTargetException()), invocationTargetException);
        }
    }

    public static Object applyStatic(Class clazz, String string, List list) {
        return Fn.applyStatic(clazz, string, list.toArray());
    }

    public static Object applyStatic(Class clazz, String string, Object[] objectArray) {
        Class[] classArray = new Class[objectArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            classArray[i] = objectArray[i].getClass();
        }
        Method method = Fn.getMethod(clazz, string, classArray);
        if (method != null) {
            return Fn.apply(null, method, objectArray);
        }
        throw new IllegalArgumentException("Could not find a " + string + " method " + "for class " + clazz + " and arguments " + Arrays.asList(objectArray));
    }

    public static Method getMethod(Object object, String string, Object[] objectArray) {
        Class<?> clazz = object.getClass();
        Class[] classArray = new Class[objectArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            classArray[i] = objectArray[i].getClass();
        }
        return Fn.getMethod(clazz, string, classArray);
    }

    public static Method getMethod(Class clazz, String string, Class[] classArray) {
        Method method = null;
        for (Method method2 : clazz.getMethods()) {
            if (!method2.getName().equals(string) || !Fn.isApplicable(method2, classArray) || method != null && !Fn.isMoreSpecific(method2, method)) continue;
            method = method2;
        }
        return method;
    }

    private static boolean isApplicable(Method method, Class[] classArray) {
        Class<?>[] classArray2 = method.getParameterTypes();
        if (classArray2.length != classArray.length) {
            return false;
        }
        for (int i = 0; i < classArray2.length; ++i) {
            if (Fn.objectClass(classArray2[i]).isAssignableFrom(classArray[i])) continue;
            return false;
        }
        return true;
    }

    private static Class objectClass(Class clazz) {
        if (!clazz.isPrimitive()) {
            return clazz;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        throw new ConsistencyException("No object class for", clazz);
    }

    private static boolean isMoreSpecific(Method method, Method method2) {
        Class<?>[] classArray;
        Class<?>[] classArray2 = method.getParameterTypes();
        Debug.expect(classArray2.length == (classArray = method2.getParameterTypes()).length);
        for (int i = 0; i < classArray2.length; ++i) {
            if (Fn.isMoreSpecific(classArray2[i], classArray[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean isMoreSpecific(Class clazz, Class clazz2) {
        return clazz2.isAssignableFrom(clazz);
    }

    public static Function1 accessor(final Class clazz, final String string) {
        final Class[] classArray = new Class[]{};
        try {
            final Method method = clazz.getMethod(string, classArray);
            return new Function1(){

                public Object funcall(Object object) {
                    try {
                        return method.invoke(object, (Object[])classArray);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new Error("Cannot access method " + string + " for class " + clazz, illegalAccessException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw new RuntimeException("Exception from method " + string + " from class " + clazz + ": " + Debug.describeException(invocationTargetException.getTargetException()), invocationTargetException);
                    }
                }
            };
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new Error("Cannot find method " + string + " for class " + clazz, noSuchMethodException);
        }
    }

    public static Function1 always(final Object object) {
        return new Function1(){

            public Object funcall(Object object2) {
                return object;
            }
        };
    }

    public static Predicate1 negate(final Predicate1 predicate1) {
        return new Predicate1(){

            public boolean trueOf(Object object) {
                return !predicate1.trueOf(object);
            }
        };
    }

    public static Predicate1 isInstanceOf(final Class clazz) {
        return new Predicate1(){

            public boolean trueOf(Object object) {
                return clazz.isInstance(object);
            }
        };
    }
}

