/*
 * Decompiled with CFR 0.152.
 */
package ix.test;

import ix.ip2.Ip2XMLConfig;
import ix.util.Debug;
import ix.util.Parameters;
import ix.util.Strings;
import ix.util.xml.FileSyntax;
import ix.util.xml.FileSyntaxManager;
import ix.util.xml.XML;
import java.io.PrintStream;
import java.util.LinkedList;

public class TranslateFile {
    static FileSyntaxManager fsm = new Ip2XMLConfig().makeFileSyntaxManager();

    public static void main(String[] stringArray) {
        Debug.off();
        Parameters.setIsInteractive(false);
        if (stringArray.length > 0 && stringArray[0].equals("-help")) {
            TranslateFile.printHelp(System.out);
            System.exit(0);
        } else if (stringArray.length < 2) {
            System.err.println("Usage: translate-file filename ... type");
            System.exit(1);
        }
        String string = stringArray[stringArray.length - 1];
        for (int i = 0; i < stringArray.length - 1; ++i) {
            TranslateFile.translateFile(stringArray[i], string);
        }
    }

    static void printHelp(PrintStream printStream) {
        LinkedList linkedList = new LinkedList();
        fsm.addAboutInfo(linkedList);
        printStream.println(Strings.joinLines(linkedList));
    }

    static void translateFile(String string, String string2) {
        System.out.println("Translating " + string);
        String string3 = fsm.getExceptType(string) + "." + string2;
        FileSyntax fileSyntax = fsm.getSyntax(string3);
        Object object = fsm.readObject(Object.class, string);
        if (fsm.canWrite(fileSyntax, object.getClass())) {
            fsm.writeObject(object, string3);
        } else {
            System.err.println("Can't translate a " + XML.nameForClass(object.getClass()) + " as a file of type " + Strings.quote(string2));
        }
    }
}

