/*
 * Decompiled with CFR 0.152.
 */
package ix.test;

import ix.icore.domain.Domain;
import ix.util.Debug;
import ix.util.Parameters;
import ix.util.Strings;
import ix.util.xml.XML;

public class CheckDomains {
    static String DASHES = Strings.repeat(30, " -");

    CheckDomains() {
    }

    public static void main(String[] stringArray) {
        Debug.off();
        Parameters.setIsInteractive(false);
        CheckDomains checkDomains = new CheckDomains();
        Debug.noteln("XML Config:", (Object)XML.config());
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            checkDomains.check(string);
        }
    }

    void check(String string) {
        this.traceln("");
        this.traceln(DASHES);
        this.traceln(string + ":");
        this.traceln("");
        Domain domain = null;
        try {
            Object object = XML.readObject(string);
            if (!(object instanceof Domain)) {
                this.traceln("Not a domain.");
                return;
            }
            domain = (Domain)object;
        }
        catch (Exception exception) {
            this.traceln("Cannot read a domain from " + string + ".  " + Debug.describeException(exception));
            return;
        }
        try {
            domain.checkConsistency();
        }
        catch (Exception exception) {
            this.traceln("Failed consistency check.");
            this.traceln("");
            this.traceln(Debug.foldException(exception));
        }
    }

    void traceln(String string) {
        System.out.println(string);
    }
}

