/*
 * Decompiled with CFR 0.152.
 */
package ix.iview.igraph;

import ix.icore.domain.Named;
import ix.icore.domain.NodeSpec;
import ix.iview.domain.UIRefinement;
import ix.iview.igraph.NodePosition;
import ix.util.Collect;
import ix.util.Debug;
import ix.util.Name;
import ix.util.lisp.LListCollector;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import lt.monarch.graph.GraphView;
import lt.monarch.graph.view.NodeView;

public class IGraph
implements Named {
    public Class nodeViewType = NodeView.class;
    public Class nodeType = Object.class;
    public String name;
    public LListCollector nodes = new LListCollector();
    private HashMap canvasPoints;
    private List autoPoints;
    protected GraphView view;

    public IGraph(String string, GraphView graphView) {
        this.name = string;
        this.view = graphView;
        this.refreshGraph(graphView);
    }

    public IGraph(String string) {
        this.name = string;
    }

    public IGraph(String string, HashMap hashMap) {
        this.name = string;
        this.setCanvasPoints(hashMap);
    }

    public IGraph(String string, List list) {
        HashMap hashMap = this.pointsListToMap(list);
        this.name = string;
        this.setCanvasPoints(hashMap);
    }

    public void refreshGraph(GraphView graphView) {
        this.view = graphView;
        Iterator iterator = graphView.nodeLayer.getViews();
        this.nodes.clear();
        NodeView nodeView = null;
        Object object = null;
        while (iterator.hasNext()) {
            nodeView = (NodeView)iterator.next();
            Point point = nodeView.getPosition();
            object = (NodeSpec)nodeView.getModelNode();
            this.nodes.add(new GraphNodeComponent(point, (NodeSpec)object));
        }
        if (nodeView != null) {
            this.nodeViewType = nodeView.getClass();
        }
        if (object != null) {
            this.nodeType = object.getClass();
        }
    }

    public Point getPosition(Object object) {
        try {
            GraphNodeComponent graphNodeComponent = (GraphNodeComponent)object;
            return graphNodeComponent.position;
        }
        catch (ClassCastException classCastException) {
            GraphNodeComponent graphNodeComponent = this.findNode(object);
            if (graphNodeComponent == null) {
                try {
                    NodeSpec nodeSpec;
                    List list;
                    if (this.canvasPoints != null && (list = (List)this.canvasPoints.get((nodeSpec = (NodeSpec)object).getId())) != null) {
                        return this.listToPoint(list);
                    }
                    return null;
                }
                catch (Exception exception) {
                    Debug.noteln("IG: getPosition cannot do node " + object.toString());
                    return null;
                }
            }
            return graphNodeComponent.position;
        }
    }

    public void setCanvasPoints(HashMap hashMap) {
        this.canvasPoints = hashMap;
    }

    public List updateCanvasPoints() {
        this.canvasPoints = this.readCanvasPoints();
        return this.pointsMapToList(this.canvasPoints);
    }

    public List getCanvasPoints() {
        return this.pointsMapToList(this.canvasPoints);
    }

    public List getGraphCanvasPoints() {
        return this.pointsMapToList(this.readCanvasPoints());
    }

    private List pointToList(Point point) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        arrayList.add(new Double(point.getX()));
        arrayList.add(new Double(point.getY()));
        return arrayList;
    }

    private Point listToPoint(List list) {
        if (list == null) {
            return null;
        }
        Double d = (Double)list.get(0);
        Double d2 = (Double)list.get(1);
        Point point = new Point(d.intValue(), d2.intValue());
        return point;
    }

    private HashMap pointsListToMap(List list) {
        if (list == null) {
            return null;
        }
        HashMap hashMap = new HashMap();
        for (Object e : list) {
            try {
                NodePosition nodePosition = (NodePosition)e;
                ArrayList<Double> arrayList = new ArrayList<Double>();
                arrayList.add(new Double(nodePosition.getX()));
                arrayList.add(new Double(nodePosition.getY()));
                hashMap.put(nodePosition.getName(), arrayList);
            }
            catch (Exception exception) {}
        }
        return hashMap;
    }

    private List pointsMapToList(HashMap hashMap) {
        if (hashMap == null) {
            return null;
        }
        ArrayList<NodePosition> arrayList = new ArrayList<NodePosition>();
        for (Name name : hashMap.keySet()) {
            List list = (List)hashMap.get(name);
            Double d = (Double)list.get(0);
            Double d2 = (Double)list.get(1);
            arrayList.add(new NodePosition(name, d, d2));
        }
        return arrayList;
    }

    public HashMap readCanvasPoints() {
        HashMap<Name, List> hashMap = new HashMap<Name, List>();
        Iterator iterator = this.nodes.iterator();
        while (iterator.hasNext()) {
            try {
                GraphNodeComponent graphNodeComponent = (GraphNodeComponent)iterator.next();
                Point point = this.getPosition(graphNodeComponent);
                Name name = graphNodeComponent.baseNode.getId();
                if (name == null || point == null) continue;
                hashMap.put(name, this.pointToList(point));
            }
            catch (Exception exception) {}
        }
        return hashMap;
    }

    public boolean isSameLayout(Object object) {
        if (object == null) {
            List list = this.getGraphCanvasPoints();
            return list == null || list.isEmpty();
        }
        if (object instanceof List) {
            return this.isSameLayoutList((List)object);
        }
        if (object instanceof HashMap) {
            return this.isSameLayoutList(this.pointsMapToList((HashMap)object));
        }
        Debug.noteln("IGraph: cannot understand positions of class", object.getClass());
        Debug.noteln(" assuming that they are the same as this.");
        return true;
    }

    private boolean isSameLayoutList(List arrayList) {
        if (this.view == null) {
            return true;
        }
        ArrayList arrayList2 = arrayList == null ? new ArrayList() : arrayList;
        try {
            return Collect.equalAsSets(this.getGraphCanvasPoints(), arrayList2);
        }
        catch (Exception exception) {
            Debug.noteException(exception);
            Debug.noteln(" assuming that the two graphs are the same.");
            return true;
        }
    }

    public void layoutFromCanvasPoints(GraphView graphView) {
        this.view = graphView;
        if (this.canvasPoints == null || this.canvasPoints.isEmpty()) {
            return;
        }
        Iterator iterator = graphView.nodeLayer.getViews();
        if (!iterator.hasNext()) {
            Debug.noteln("IG: graph view has no nodes");
            new Throwable().printStackTrace();
        }
        while (iterator.hasNext()) {
            try {
                NodeView nodeView = (NodeView)iterator.next();
                NodeSpec nodeSpec = (NodeSpec)nodeView.getModelNode();
                List list = (List)this.canvasPoints.get(nodeSpec.getId());
                Point point = this.listToPoint(list);
                if (point != null) {
                    nodeView.setPosition(point);
                    continue;
                }
                Debug.noteln("got no position for", (Object)nodeSpec.getId());
            }
            catch (Exception exception) {
                Debug.noteln("layout from canvas problem:", (Object)exception.getMessage());
            }
        }
    }

    protected GraphNodeComponent findNode(Object object) {
        Enumeration enumeration = this.nodes.elements();
        while (enumeration.hasMoreElements()) {
            GraphNodeComponent graphNodeComponent = (GraphNodeComponent)enumeration.nextElement();
            if (!UIRefinement.isRef(graphNodeComponent.baseNode, object)) continue;
            return graphNodeComponent;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private class GraphNodeComponent {
        public Point position;
        public double width;
        public double height;
        public NodeSpec baseNode;

        public GraphNodeComponent(Point point, NodeSpec nodeSpec) {
            this.position = point;
            this.baseNode = nodeSpec;
        }

        public GraphNodeComponent(Point point, double d, double d2, NodeSpec nodeSpec) {
            this(point, nodeSpec);
            this.width = d;
            this.height = d2;
        }
    }
}

