/*
 * Decompiled with CFR 0.152.
 */
package ix.iview;

import ix.icore.domain.VariableDeclaration;
import ix.iface.ui.util.UIUtil;
import ix.iview.ConstraintEditor;
import ix.iview.domain.UIRefinement;
import ix.iview.util.IVUtil;
import ix.util.Debug;
import ix.util.lisp.ItemVar;
import ix.util.lisp.Symbol;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class SimpleDeclarationEditor
extends ConstraintEditor {
    protected JTextArea varList;
    protected JRadioButton used;
    protected JRadioButton any;
    protected JRadioButton given;
    protected JRadioButton none;
    protected JButton add;
    protected JButton delete;
    private ButtonGroup group;

    public SimpleDeclarationEditor(Frame frame) {
        super(frame, "Simple Variable Declaration Editor", "Please specify the variable declarations");
    }

    public SimpleDeclarationEditor(Frame frame, UIRefinement uIRefinement) {
        this(frame);
        this.setObject(uIRefinement);
    }

    protected Component makeRels() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel("Variable declarations");
        this.varList = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane(this.varList);
        this.used = new JRadioButton("Currently Used");
        this.any = new JRadioButton("Any");
        this.none = new JRadioButton("None");
        this.given = new JRadioButton("As Given Here");
        this.group = new ButtonGroup();
        this.group.add(this.used);
        this.group.add(this.any);
        this.group.add(this.none);
        this.group.add(this.given);
        this.any.setActionCommand("Any");
        this.any.setToolTipText("Allow any variables");
        this.none.setActionCommand("None");
        this.none.setToolTipText("Allow no variables");
        this.used.setActionCommand("Currently Used");
        this.used.setToolTipText("Allow only currently used variables");
        this.given.setActionCommand("As Given Here");
        this.given.setToolTipText("Allow only given variables");
        this.any.addMouseListener(this);
        this.used.addMouseListener(this);
        this.none.addMouseListener(this);
        this.given.addMouseListener(this);
        this.any.setSelected(true);
        this.add = new JButton("Add");
        this.delete = new JButton("Delete");
        this.add.addMouseListener(this);
        this.delete.addMouseListener(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 2, 0, 12), 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 0, 1.0, 1.0, 18, 1, new Insets(0, 2, 0, 2), 0, 0);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0);
        jPanel.add((Component)this.any, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0);
        jPanel.add((Component)this.used, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0);
        jPanel.add((Component)this.given, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0);
        jPanel.add((Component)this.none, gridBagConstraints);
        return jPanel;
    }

    protected void initFromObject() throws NullPointerException {
        UIRefinement uIRefinement = (UIRefinement)this.currentObject;
        if (uIRefinement == null) {
            return;
        }
        List list = uIRefinement.getVariableDeclarations();
        Vector vector = list != null ? new Vector(list) : new Vector();
        this.setListData(vector);
        if (list == null) {
            Debug.noteln("DecE: got no declarations");
            this.any.setSelected(true);
        } else if (vector.size() == 0) {
            this.none.setSelected(true);
        } else {
            boolean bl = true;
            SortedSet sortedSet = uIRefinement.getVariablesUsed();
            Iterator iterator = list.iterator();
            while (bl && iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof VariableDeclaration) {
                    if (sortedSet.contains(((VariableDeclaration)e).getName())) continue;
                    bl = false;
                    continue;
                }
                if (sortedSet.contains(e)) continue;
                bl = false;
            }
            if (bl) {
                this.used.setSelected(true);
            } else {
                this.given.setSelected(true);
            }
        }
    }

    public void setListData(Collection collection) {
        this.varList.setText("");
        String string = "";
        for (Object object : collection) {
            if (object instanceof VariableDeclaration) {
                object = ((VariableDeclaration)object).getName();
            }
            ItemVar itemVar = (ItemVar)object;
            if (string == "") {
                string = string + itemVar.toString();
                continue;
            }
            string = string + UIUtil.lineSeparator + itemVar.toString();
        }
        this.varList.setText(string);
    }

    protected void setFromObject(Object object) {
    }

    private void setUsed() {
        UIRefinement uIRefinement = (UIRefinement)this.currentObject;
        SortedSet sortedSet = uIRefinement.getVariablesUsed();
        if (sortedSet == null || sortedSet.size() == 0) {
            this.none.setSelected(true);
        } else {
            this.setListData(sortedSet);
            this.used.setSelected(true);
        }
    }

    protected Object collectConstraint() {
        String[] stringArray;
        String string = this.varList.getText();
        ArrayList<VariableDeclaration> arrayList = new ArrayList<VariableDeclaration>();
        if (string != "") {
            while (!string.equals("")) {
                Symbol symbol;
                stringArray = UIUtil.breakStringAtFirst(string, "\n");
                String string2 = IVUtil.ensureVarName(stringArray[0].trim());
                if (string2 != "" && (symbol = Symbol.intern(string2)) != null) {
                    arrayList.add(new VariableDeclaration((ItemVar)symbol));
                }
                string = stringArray[1];
            }
        }
        if (arrayList.size() > 0) {
            this.varDecs = arrayList;
            return new ArrayList(this.varDecs);
        }
        stringArray = this.group.getSelection();
        if (stringArray.getActionCommand() != null && (stringArray.getActionCommand().equals("None") || stringArray.getActionCommand().equals("Given") || stringArray.getActionCommand().equals("As Given Here"))) {
            this.varDecs = new ArrayList();
            return new ArrayList();
        }
        this.varDecs = null;
        return "any";
    }

    protected void handleVariables() {
        try {
            UIRefinement uIRefinement = (UIRefinement)this.currentObject;
            if (this.varDecs != null) {
                uIRefinement.setVariableDeclarations(new ArrayList(this.varDecs));
                this.varDecs.clear();
            } else {
                uIRefinement.setVariableDeclarations(null);
            }
        }
        catch (Exception exception) {
            Debug.noteException(exception);
        }
    }

    protected Object noteNewValue(Object object) {
        try {
            UIRefinement uIRefinement = (UIRefinement)this.currentObject;
            List list = uIRefinement.getVariableDeclarations();
            return list;
        }
        catch (Exception exception) {
            Debug.noteException(exception);
            return object;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.any || mouseEvent.getSource() == this.none) {
            this.varList.setText("");
        } else if (mouseEvent.getSource() == this.used) {
            this.setUsed();
        } else if (mouseEvent.getSource() != this.given) {
            super.mouseClicked(mouseEvent);
        }
    }

    public void start() {
        this.moreBut.setVisible(false);
        this.moreBut.setEnabled(false);
        super.start();
    }
}

