/*
 * Decompiled with CFR 0.152.
 */
package ix.iview;

import ix.icore.IXObject;
import ix.icore.domain.Named;
import ix.icore.domain.Refinement;
import ix.iface.domain.SyntaxException;
import ix.iface.ui.IXEditorPanel;
import ix.iface.ui.table.AbstractIXTableModel;
import ix.iface.ui.table.IXTreeTable;
import ix.iface.ui.util.UIUtil;
import ix.iview.AConstructFramePanel;
import ix.iview.DomainEditor;
import ix.iview.DomainEditorFrame;
import ix.iview.DomainFormModel;
import ix.iview.GlobalFormPanel;
import ix.iview.domain.UIDomain;
import ix.iview.domain.UINodeSpec;
import ix.iview.domain.UIObject;
import ix.iview.domain.UIRefinement;
import ix.iview.event.CurrentActionListener;
import ix.util.Debug;
import ix.util.TextAreaFrame;
import ix.util.lisp.ItemVar;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class GlobalFramePanel
extends AConstructFramePanel
implements CurrentActionListener {
    public GlobalFramePanel() {
    }

    public GlobalFramePanel(DomainEditorFrame domainEditorFrame) {
        super(domainEditorFrame);
        DomainFormModel domainFormModel = new DomainFormModel();
        String[] stringArray = new String[]{"refinements", "objectClasses", "comments"};
        domainFormModel.setDisplayFields(stringArray);
        this.formPanel.setModel(domainFormModel);
        this.formPanel.addFormActionListener(this);
        this.hasOverview = true;
        this.setSort(DEFAULT_SORT);
        UIDomain uIDomain = this.parent.getUIDomain();
        this.setUIConstruct(uIDomain);
        uIDomain.addUIDomainListener((GlobalFormPanel)this.formPanel);
    }

    protected JPanel setupMainPanel() {
        this.formPanel = new GlobalFormPanel(this);
        return this.formPanel;
    }

    protected UIObject cloneConstruct(UIObject uIObject) {
        return null;
    }

    protected void setConstructFields() {
    }

    public List getAllConstructs() {
        return null;
    }

    public void newConstruct() {
        this.notImp("Creating a new domain");
    }

    public UIObject makeNewConstruct() {
        return new UIDomain(this.parent.editor());
    }

    public boolean checkConstruct() {
        try {
            if (this.parent.getUIDomain() != null) {
                this.parent.getUIDomain().checkAndReportConsistency();
            }
            return true;
        }
        catch (SyntaxException syntaxException) {
            JOptionPane.showMessageDialog(this, syntaxException.getMessage());
            return false;
        }
    }

    public void viewChanges() {
        UIDomain uIDomain = this.parent.getUIDomain();
        if (uIDomain == null) {
            JOptionPane.showMessageDialog(this, "No construct to check");
        } else {
            List list = uIDomain.collectChanges();
            if (list == null || list.size() == 0) {
                JOptionPane.showMessageDialog(this, "No changes found");
            } else {
                TextAreaFrame textAreaFrame = new TextAreaFrame("Changes for " + uIDomain.getName());
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    textAreaFrame.appendLine((String)iterator.next());
                }
                textAreaFrame.setVisible(true);
            }
        }
    }

    public void viewChangesFromOriginal() {
        UIDomain uIDomain = this.parent.getUIDomain();
        if (uIDomain == null) {
            JOptionPane.showMessageDialog(this, "No construct to check");
        } else {
            List list = uIDomain.collectChangesFromOriginal();
            if (list == null || list.size() == 0) {
                JOptionPane.showMessageDialog(this, "No changes found");
            } else {
                TextAreaFrame textAreaFrame = new TextAreaFrame("Changes for " + uIDomain.getName());
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    textAreaFrame.appendLine((String)iterator.next());
                }
                textAreaFrame.setVisible(true);
            }
        }
    }

    public void saveConstruct() {
        this.noteConstruct();
    }

    public void revertConstruct() {
        UIDomain uIDomain = this.parent.getUIDomain();
        uIDomain.loadFromDomain();
        this.setUIConstruct(uIDomain);
    }

    public void revertOConstruct() {
        UIDomain uIDomain = this.parent.getUIDomain();
        uIDomain.loadFromOriginal();
        this.setUIConstruct(uIDomain);
    }

    protected UIObject noteConstruct() {
        UIDomain uIDomain = this.parent.getUIDomain();
        this.formPanel.saveToObject(uIDomain);
        Debug.noteln(" new name:", (Object)uIDomain.getName());
        uIDomain.saveToDomain();
        this.setUIConstruct(uIDomain);
        return uIDomain;
    }

    public Named getNamedConstruct(String string) {
        if (this.parent.getUIDomain() == null) {
            return null;
        }
        if (this.parent.getUIDomain().getName().equals(string)) {
            return this.parent.getUIDomain();
        }
        return null;
    }

    public void clear() {
        this.parent.getUIDomain().clear();
        this.refresh();
    }

    public void refresh() {
        this.setUIConstruct(this.parent.getUIDomain());
    }

    public void setSort(boolean bl) {
        ((GlobalFormPanel)this.formPanel).setSort(bl);
    }

    public boolean getSort() {
        return ((GlobalFormPanel)this.formPanel).getSort();
    }

    public void userDeclareVariables() {
        Debug.noteln("GFP: Declaring variables in domain", (Object)this.parent.getUIDomain());
        this.parent.getUIDomain().declareAllVariables();
    }

    public void userFindVariables() {
        UIDomain uIDomain = this.parent.getUIDomain();
        Set set = uIDomain.findVariablesUsed();
        if (set == null || set.size() == 0) {
            JOptionPane.showMessageDialog(this, "No variables used");
        } else {
            Object[] objectArray = set.toArray();
            String[] stringArray = new String[]{"The refinements in the domain " + uIDomain.getName() + " use the variables listed below", "To find refinements that use a listed variable select it in the list and click ok."};
            Object object = JOptionPane.showInputDialog(this.parent, stringArray, "Variables Used", 1, null, objectArray, objectArray[0]);
            if (object != null && object != "") {
                Collection collection = uIDomain.findVariableUsers((ItemVar)object);
                if (collection == null || collection.size() == 0) {
                    JOptionPane.showMessageDialog(this, "Cannot find refinements using" + object);
                } else {
                    try {
                        Object[] objectArray2 = collection.toArray();
                        String[] stringArray2 = new String[]{"The refinements in the domain " + uIDomain.getName() + " that use variable " + object + " are listed below", "To go straight to editing a listed refinement,", " select it in the list and click ok."};
                        Object object2 = JOptionPane.showInputDialog(this.parent, stringArray2, "Refinements Using" + object, 1, null, objectArray2, objectArray2[0]);
                        if (object2 != null) {
                            Refinement refinement = (Refinement)object2;
                            this.parent.editor().setConstruct(refinement);
                        }
                    }
                    catch (Exception exception) {
                        Debug.noteException(exception);
                    }
                }
            }
        }
    }

    private void userDeleteItem(IXEditorPanel iXEditorPanel) {
        List list = this.getClearSelection(iXEditorPanel);
        if (list != null) {
            for (Object e : list) {
                try {
                    this.getUIDomain().removeConstruct((UIObject)e);
                }
                catch (ClassCastException classCastException) {
                    try {
                        this.getUIDomain().removeConstruct((Named)e);
                    }
                    catch (ClassCastException classCastException2) {
                        Debug.noteln("Domain Editor: Cannot delete things of class", (Object)e.getClass().getName());
                    }
                }
            }
        }
    }

    private void userEditItem(IXEditorPanel iXEditorPanel) {
        List list = this.getClearSelection(iXEditorPanel);
        if (list != null && !list.isEmpty()) {
            Object e = list.get(0);
            try {
                this.getEditor().setConstruct((IXObject)e);
            }
            catch (ClassCastException classCastException) {
                Debug.noteln("GFrP: not ix - trying ui");
                try {
                    this.getEditor().setUIConstruct((UIObject)e);
                }
                catch (ClassCastException classCastException2) {
                    Debug.noteln("GFrP: not ix or ui - trying nodeSpec");
                    try {
                        UINodeSpec uINodeSpec = (UINodeSpec)e;
                        UIRefinement uIRefinement = new UIRefinement(this.getUIDomain());
                        uIRefinement.setPattern(uINodeSpec.getPattern());
                        if (uIRefinement.getName() == null) {
                            uIRefinement.setName("undefined");
                        }
                        this.getEditor().setUIConstruct(uIRefinement);
                    }
                    catch (ClassCastException classCastException3) {
                        Debug.noteln("Domain Editor: Cannot edit things of class", (Object)e.getClass().getName());
                    }
                }
            }
        }
    }

    private DomainEditor getEditor() {
        return this.parent.editor();
    }

    private List getClearSelection(IXEditorPanel iXEditorPanel) {
        JComponent jComponent = iXEditorPanel.getItemComponent();
        if (jComponent instanceof IXTreeTable) {
            IXTreeTable iXTreeTable = (IXTreeTable)jComponent;
            int[] nArray = iXTreeTable.getSelectedRows();
            iXTreeTable.clearSelection();
            if (nArray.length == 0) {
                this.complainNoSelection(iXEditorPanel);
                return null;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            AbstractIXTableModel abstractIXTableModel = (AbstractIXTableModel)iXTreeTable.getModel();
            for (int i = 0; i < nArray.length; ++i) {
                arrayList.add(abstractIXTableModel.getRowObject(nArray[i]));
            }
            return arrayList;
        }
        if (jComponent instanceof JList) {
            List<Object> list = Arrays.asList(((JList)jComponent).getSelectedValues());
            ((JList)jComponent).clearSelection();
            if (list == null || list.isEmpty()) {
                this.complainNoSelection(iXEditorPanel);
                return null;
            }
            return list;
        }
        return null;
    }

    private void complainNoSelection(IXEditorPanel iXEditorPanel) {
        String string = "Please select an item from the list first.";
        JOptionPane.showMessageDialog(this.parent, string);
    }

    public void addCurrentActionListener(CurrentActionListener currentActionListener) {
        ((GlobalFormPanel)this.formPanel).addCurrentActionListener(currentActionListener);
    }

    public void actionChanged(Component component, UIRefinement uIRefinement, UIRefinement uIRefinement2) {
        if (this.equals(component)) {
            return;
        }
        ((GlobalFormPanel)this.formPanel).reactingActionChange(true);
        ((GlobalFormPanel)this.formPanel).setSelectedAction(uIRefinement2);
        ((GlobalFormPanel)this.formPanel).reactingActionChange(false);
    }

    public boolean frameActionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Debug.noteln("DomainFramePanel got frame action command", (Object)string);
        if (string == "newConstruct") {
            this.newConstruct();
        } else if (string == "editConstruct") {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string2 = jMenuItem.getText().trim();
            this.setUIConstruct((UIObject)this.getNamedConstruct(string2));
        } else if (string == "modify") {
            this.saveConstruct();
        } else if (string == "revert") {
            this.revertConstruct();
        } else if (string == "revertO") {
            this.revertOConstruct();
        } else if (string == "check") {
            this.checkConstruct();
        } else if (string == "declareVars") {
            this.userDeclareVariables();
        } else if (string == "findVars") {
            this.userFindVariables();
        } else {
            return false;
        }
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (this.frameActionPerformed(actionEvent)) {
            return;
        }
        if (this.buttonActionPerformed(actionEvent)) {
            return;
        }
        Debug.noteln("GlobalFramePanel cannot recognise command", (Object)string);
    }

    private boolean buttonActionPerformed(ActionEvent actionEvent) {
        IXEditorPanel iXEditorPanel = UIUtil.getEventPanel(actionEvent);
        if (iXEditorPanel == null) {
            return false;
        }
        String string = iXEditorPanel.getName();
        if (string == null) {
            return false;
        }
        String string2 = actionEvent.getActionCommand();
        if (string2 == null) {
            return false;
        }
        Debug.noteln("Global Domain Panel got button action command", (Object)string2);
        if (string2.equals("Delete")) {
            this.userDeleteItem(iXEditorPanel);
            return true;
        }
        if (string2.equals("Edit")) {
            this.userEditItem(iXEditorPanel);
            return true;
        }
        if (string.equals("ObjectClasses")) {
            if (!string2.equals("Add")) {
                UIUtil.notImplemented(null, string2 + " for object classes");
                return false;
            }
            String string3 = "Please use the Objects panel to add object classes.";
            JOptionPane.showMessageDialog(null, string3);
            return true;
        }
        if (string.equals("Refinements")) {
            if (!string2.equals("Add")) {
                UIUtil.notImplemented(null, string2 + " for refinements");
                return false;
            }
            this.getEditor().setConstruct(new Refinement());
            return true;
        }
        UIUtil.notImplemented(null, "Command " + string2);
        return false;
    }

    protected void notImp(String string) {
        UIUtil.notImplemented(this, string);
    }
}

