/*
 * Decompiled with CFR 0.152.
 */
package ix.iview;

import ix.icore.domain.Constraint;
import ix.icore.domain.PatternAssignment;
import ix.iface.ui.util.UIUtil;
import ix.iview.ConstraintEditor;
import ix.iview.domain.UIRefinement;
import ix.iview.util.IVUtil;
import ix.util.Debug;
import ix.util.Strings;
import ix.util.lisp.LList;
import ix.util.lisp.LListCollector;
import ix.util.lisp.Lisp;
import ix.util.lisp.Symbol;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class DefaultConstraintEditor
extends ConstraintEditor {
    protected JTextField typeField;
    protected JTextField relField;
    protected JRadioButton condBut;
    protected JRadioButton effBut;
    private ButtonGroup group;
    protected JTextField statement;

    public DefaultConstraintEditor(Frame frame) {
        super(frame, "Constraint Editor", "Please specify a constraint");
    }

    public DefaultConstraintEditor(Frame frame, UIRefinement uIRefinement) {
        this(frame);
        this.setObject(uIRefinement);
    }

    protected Component makeRels() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel("Constraint type");
        JLabel jLabel2 = new JLabel("Constraint relation (sub-type)");
        this.typeField = new JTextField();
        this.relField = new JTextField();
        JLabel jLabel3 = new JLabel("Parameters (pattern and value)");
        this.statement = new JTextField();
        IVUtil.enableVars(this, this.statement);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 2, 0, 12), 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 2, 0, 2), 0, 0);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 2, 0, 12), 0, 0);
        jPanel.add((Component)this.typeField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 2, 0, 2), 0, 0);
        jPanel.add((Component)this.relField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0);
        jPanel.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 16, 2, new Insets(0, 2, 0, 2), 0, 0);
        jPanel.add((Component)this.statement, gridBagConstraints);
        return jPanel;
    }

    protected JComponent getFocusComponent() {
        return this.typeField;
    }

    protected void initFromObject() throws NullPointerException {
        this.typeField.setText("");
        this.relField.setText("");
        this.statement.setText("");
    }

    protected void setFromObject(Object object) {
        this.typeField.setText("");
        this.relField.setText("");
        this.statement.setText("");
        if (object == null) {
            return;
        }
        if (!(object instanceof Constraint)) {
            String string = "Condition/Effect editor can only deal with constraints not objects of class " + object.getClass().getName();
            JOptionPane.showMessageDialog(this, string);
            return;
        }
        Constraint constraint = (Constraint)object;
        this.typeField.setText(constraint.getType().toString());
        if (constraint.getRelation() == null) {
            this.relField.setText("");
        } else {
            this.relField.setText(constraint.getRelation().toString());
        }
        this.statement.setText(IVUtil.printConstraintParameters(constraint));
    }

    protected Object collectConstraint() {
        String string = this.typeField.getText().trim();
        String string2 = this.relField.getText().trim();
        Symbol symbol = Symbol.valueOf(string);
        Symbol symbol2 = Symbol.valueOf(string2);
        String string3 = this.statement.getText().trim();
        Constraint constraint = null;
        try {
            constraint = IVUtil.readCondition(symbol, symbol2, string3);
        }
        catch (Exception exception) {
            Debug.noteln("DefCEd: constraint not a condition");
            try {
                List list = this.readParameters(string3);
                constraint = new Constraint();
                constraint.setType(symbol);
                if (symbol2 != null) {
                    constraint.setRelation(symbol2);
                }
                constraint.setParameters(list);
            }
            catch (Exception exception2) {
                Debug.noteException(exception2);
                JOptionPane.showMessageDialog(this, "Constraint Editor: " + Debug.foldException(exception2));
            }
        }
        Debug.noteln("DefCEd: new constraint is", (Object)constraint);
        if (this.isEditing()) {
            try {
                Constraint constraint2 = (Constraint)((Constraint)this.original).clone();
                constraint2.setType(symbol);
                constraint2.setRelation(symbol2);
                if (constraint != null) {
                    constraint2.setParameters(constraint.getParameters());
                }
                Debug.noteln("DConstrEd: got constraint", (Object)constraint2);
                return constraint2;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                Debug.describeException(cloneNotSupportedException);
                JOptionPane.showMessageDialog(this, "Constraint Editor: " + Debug.foldException(cloneNotSupportedException));
                return null;
            }
        }
        return constraint;
    }

    protected List readParameters(String string) {
        String[] stringArray = Strings.breakAtFirst("=", string);
        String string2 = UIUtil.ensureParenthesized(stringArray[0].trim());
        String string3 = stringArray[1].trim();
        if (string3.equals("")) {
            string3 = "true";
        }
        String string4 = "(" + string2 + " = " + string3 + ")";
        LList lList = (LList)Lisp.readFromString(string4);
        LListCollector lListCollector = new LListCollector();
        lListCollector.add(new PatternAssignment((LList)lList.car(), string3));
        return lListCollector.contents();
    }
}

