/*
 * Decompiled with CFR 0.152.
 */
package ix.iscript;

import ix.iscript.And;
import ix.iscript.Assignment;
import ix.iscript.Binding;
import ix.iscript.Call;
import ix.iscript.Expression;
import ix.iscript.If;
import ix.iscript.Lambda;
import ix.iscript.Let;
import ix.iscript.LinkedListOfBinding;
import ix.iscript.ListOfBinding;
import ix.iscript.ListOfExpression;
import ix.iscript.Literal;
import ix.iscript.Or;
import ix.iscript.Sequence;
import ix.iscript.VarRef;
import ix.iscript.While;
import ix.util.LinkedListOfName;
import ix.util.ListOfName;
import ix.util.Name;
import ix.util.lisp.Symbol;
import java.util.ListIterator;

public class IScript {
    public Literal makeLiteral(Object object) {
        Literal literal = new Literal();
        literal.setValue(object);
        return literal;
    }

    public VarRef makeVarRef(Symbol symbol) {
        return this.makeVarRef(Name.valueOf(symbol));
    }

    public VarRef makeVarRef(Name name) {
        VarRef varRef = new VarRef();
        varRef.setName(name);
        return varRef;
    }

    public Call makeCall(Expression expression, ListOfExpression listOfExpression) {
        Call call = new Call();
        call.setFunction(expression);
        call.setArguments(listOfExpression);
        return call;
    }

    public Assignment makeAssignment(Symbol symbol, Expression expression) {
        return this.makeAssignment(Name.valueOf(symbol), expression);
    }

    public Assignment makeAssignment(Name name, Expression expression) {
        Assignment assignment = new Assignment();
        assignment.setTo(name);
        assignment.setValue(expression);
        return assignment;
    }

    public If makeIf(Expression expression, Expression expression2, Expression expression3) {
        If if_ = new If();
        if_.setTest(expression);
        if_.setIfTrue(expression2);
        if_.setIfFalse(expression3);
        return if_;
    }

    public Sequence makeSequence(ListOfExpression listOfExpression) {
        Sequence sequence = new Sequence();
        sequence.setOf(listOfExpression);
        return sequence;
    }

    public And makeAnd(ListOfExpression listOfExpression) {
        And and = new And();
        and.setOf(listOfExpression);
        return and;
    }

    public Or makeOr(ListOfExpression listOfExpression) {
        Or or = new Or();
        or.setOf(listOfExpression);
        return or;
    }

    public Let makeLet(Symbol[] symbolArray, ListOfExpression listOfExpression, Expression expression) {
        LinkedListOfBinding linkedListOfBinding = new LinkedListOfBinding();
        ListIterator listIterator = listOfExpression.listIterator();
        while (listIterator.hasNext()) {
            Name name = Name.valueOf(symbolArray[listIterator.nextIndex()]);
            Expression expression2 = (Expression)listIterator.next();
            linkedListOfBinding.add(this.makeBinding(name, expression2));
        }
        return this.makeLet(linkedListOfBinding, expression);
    }

    public Let makeLet(ListOfBinding listOfBinding, Expression expression) {
        Let let = new Let();
        let.setBindings(listOfBinding);
        let.setIn(expression);
        return let;
    }

    public Binding makeBinding(Name name, Expression expression) {
        Binding binding = new Binding();
        binding.setName(name);
        binding.setValue(expression);
        return binding;
    }

    public Lambda makeLambda(Symbol[] symbolArray, Expression expression) {
        LinkedListOfName linkedListOfName = new LinkedListOfName();
        for (int i = 0; i < symbolArray.length; ++i) {
            linkedListOfName.add(Name.valueOf(symbolArray[i]));
        }
        return this.makeLambda(linkedListOfName, expression);
    }

    public Lambda makeLambda(ListOfName listOfName, Expression expression) {
        Lambda lambda = new Lambda();
        lambda.setParameters(listOfName);
        lambda.setIn(expression);
        return lambda;
    }

    public While makeWhile(Expression expression, Expression expression2) {
        While while_ = new While();
        while_.setTest(expression);
        while_.setRepeat(expression2);
        return while_;
    }
}

